# 视频去重助手 v1.1.0

## 📋 项目说明

一个功能强大的视频去重工具，帮助苹果CMS用户快速检测和移除重复视频，支持7种去重模式和5种保留规则。

## ✨ 核心功能

### 7种去重模式
1. **按标题完全匹配** - 精确查找完全相同的标题
2. **按标题模糊匹配** - 模糊查找相似标题
3. **按播放链接** - 相同播放源视频
4. **按内容哈希值** - 基于标题和播放链接生成的哈希值
5. **按标题+演员组合** - 组合条件精准匹配
6. **按标题+年代组合** - 同一时期的相同标题
7. **按标题+分类组合** - 同一分类中的相同标题

### 5种保留规则
1. **保留最新添加** - 删除旧视频，保留新上传的
2. **保留最早添加** - 保留原始视频，删除后期重复
3. **保留播放最多** - 删除热度低的，保留热门视频
4. **保留评分最高** - 删除评分低的，保留高分视频
5. **合并视频** - 保留一个视频，将其他视频的播放源合并进去

## 📁 目录结构

```
quchong_duplication/
├── index.html                  # 前端管理界面
├── config.php                  # 数据库配置文件
├── api/
│   └── action.php             # 后端API处理接口
├── class/
│   └── QuchongDuplication.php  # 核心去重类
├── logs/                       # 操作日志目录
├── backup/                     # 备份数据目录
└── README.md                   # 本文件
```

## 🚀 快速开始

### 1. 数据库配置

编辑 `config.php` 文件，修改数据库连接信息：

```php
define('DB_HOST', 'localhost');
define('DB_USER', 'root');
define('DB_PASS', '你的密码');
define('DB_NAME', 'maccms');
define('DB_PORT', 3306);
define('DB_PREFIX', 'mac_');  // 数据库表前缀
```

### 2. 访问程序

在浏览器中访问：`http://你的域名/quchong_duplication/index.html`

### 3. 使用步骤

1. 打开程序，查看统计信息（右侧栏）
2. 选择合适的**去重模式**
3. 选择**保留规则**
4. 点击"🔎 检测重复"按钮
5. 程序会列出所有找到的重复视频组
6. 勾选要操作的视频
7. 选择"🗑️ 删除选中"或"🔗 合并选中"

## 🔧 功能详解

### 检测重复

系统根据选择的模式检测重复视频，支持自定义查询限制。

### 删除操作

- **自动备份**：删除前自动备份数据到 `backup/` 目录
- **保留规则应用**：根据规则自动选择保留视频，其他删除
- **操作日志**：所有操作记录在 `logs/` 目录

### 合并操作

- **保留一个视频**：指定保留的主视频ID
- **合并播放源**：将删除视频的播放源合并到主视频
- **自动去重**：避免播放源重复

## 📊 API 接口

### 检测重复
```
POST /api/action.php
action=detect&mode=title&limit=1000
```

### 删除视频
```
POST /api/action.php
action=remove&ids=1,2,3&rule=newest
```

### 合并视频
```
POST /api/action.php
action=merge&keep_id=1&delete_ids=2,3
```

### 获取统计
```
GET /api/action.php?action=stats
```

### 获取模式列表
```
GET /api/action.php?action=modes
```

### 获取保留规则
```
GET /api/action.php?action=rules
```

## ⚠️ 注意事项

1. **备份重要**：所有删除操作都会自动备份到 `backup/` 目录
2. **数据库权限**：确保数据库用户有足够的删除和修改权限
3. **表前缀**：根据你的CMS配置修改 `DB_PREFIX`
4. **日志查看**：操作日志保存在 `logs/` 目录，可用于审计

## 🔐 安全建议

1. 在生产环境前先在测试库进行测试
2. 定期备份数据库
3. 检查 `logs/` 目录了解所有操作
4. 根据情况限制对该程序的访问权限

## 🐛 故障排查

### 无法连接数据库
- 检查 `config.php` 中的数据库配置
- 确认数据库服务运行正常
- 验证数据库用户密码

### 检测不到重复
- 选择合适的去重模式
- 检查数据库中是否确实有重复数据
- 查看 `logs/` 目录获取详细错误信息

### 删除失败
- 检查数据库用户权限
- 查看 `logs/` 目录的错误日志
- 确保 `backup/` 目录有写入权限

## 📝 版本历史

### v1.1.0
- ✨ 7种去重模式
- ✨ 5种保留规则
- ✨ 视频合并功能
- ✨ 自动备份机制
- ✨ 操作日志记录
- ✨ 响应式前端界面

## 👨‍💻 开发者

视频去重助手 - 专业的视频重复检测和管理工具

## 📄 许可证

MIT License

---

**需要帮助？** 查看 `logs/` 目录下的日志文件获取详细的操作记录和错误信息。
