# 系统诊断和故障排查指南

## 问题：统计信息显示 undefined

当你看到统计信息显示 `undefined` 时，通常是以下几个原因导致的：

### 1. **数据库配置错误**

**症状：**
- 统计信息显示 undefined
- 诊断页面显示"连接失败"

**解决方案：**

检查 `/application/database.php` 配置文件中的内容是否正确：

```php
<?php
return [
    'default' => 'mysql',
    'mysql' => [
        'type'       => 'mysql',
        'hostname'   => 'localhost',   // 数据库主机
        'database'   => 'maccms',      // 数据库名称
        'username'   => 'root',        // 用户名
        'password'   => '',            // 密码
        'hostport'   => '3306',        // 端口
        'prefix'     => 'mac_',        // 表前缀
    ]
];
```

### 2. **表前缀不匹配**

**症状：**
- 连接成功，但检测到"表不存在"

**原因：**
- 数据库表前缀与配置不一致
- 最常见的表前缀：`mac_`, `maccms_`, `ys_`

**解决方案：**

访问 `debug.html` 查看诊断信息，查看配置的表前缀是否正确。

如果前缀错误，修改 `/application/database.php` 中的 `'prefix'` 字段。

### 3. **表结构不正确**

**症状：**
- 表存在，但检测返回空结果或错误

**解决方案：**

确保数据库中存在以下字段：
- `id` - 视频ID
- `title` - 视频标题
- `vod_play_url` - 播放链接
- `vod_play_from` - 播放源
- `vod_actor` - 演员
- `vod_time` - 上传时间
- `vod_hits` - 播放次数
- `vod_score` - 评分
- `type_id` - 分类ID

## 诊断工具使用

### 1. 打开诊断页面

在浏览器中访问：`http://你的域名/quchong_duplication/debug.html`

### 2. 查看诊断信息

**数据库配置检测** 部分会显示：
- ✓ 已连接 - 数据库连接成功
- ✗ 连接失败 - 检查连接信息
- ✓ 表存在 - 视频表存在
- ✗ 表不存在 - 检查表前缀

### 3. 查看API测试结果

点击各个测试按钮，查看API返回的JSON结果，判断具体的错误信息。

### 4. 查看日志

**最近日志** 部分显示程序运行的详细日志，帮助定位问题。

## 常见问题排查流程

```
统计信息显示 undefined
    ↓
访问 debug.html
    ↓
检查"数据库配置检测"
    ├─→ 连接失败 → 检查数据库地址、用户名、密码
    ├─→ 表不存在 → 检查表前缀是否正确
    └─→ 都正常 → 继续↓
    
点击"测试统计接口"按钮
    ↓
查看返回的JSON结果
    ├─→ "error" 字段有内容 → 按错误信息排查
    └─→ 显示正确的统计数据 → 刷新主页面
```

## 日志文件位置

所有操作日志保存在：`/logs/` 目录

- `YYYY-MM-DD.log` - 当天的日志文件
- 每次操作都会记录详细信息

## 重置和恢复

如果怀疑配置文件被修改，可以：

1. **删除缓存**
   - 清除浏览器缓存
   - 删除 `/quchong_duplication/logs/` 目录内容

2. **重新加载配置**
   - 重启PHP服务
   - 或刷新浏览器

3. **检查备份**
   - 删除操作的备份保存在 `/backup/` 目录
   - 可以通过备份文件恢复数据

## 性能优化建议

如果数据库很大（超过100万条记录）：

1. **调整查询限制**
   - 在主界面的"查询限制"中减小值（如改为100）
   - 这样可以加快检测速度

2. **分批处理**
   - 不要一次删除太多视频
   - 建议每次删除不超过1000个

3. **定期备份**
   - 重要的操作前一定要备份
   - 程序会自动备份，但也要手动备份数据库

## 无法解决时

1. 收集以下信息：
   - `debug.html` 诊断页面的截图
   - `/logs/` 目录中最新日志文件的内容
   - `/application/database.php` 配置内容（隐藏密码）

2. 检查PHP错误日志（通常在服务器的 error_log 文件中）

3. 确保PHP版本 >= 5.6
