<?php
/**
 * 数据库诊断接口
 */

require_once dirname(__FILE__) . '/../config.php';

header('Content-Type: application/json; charset=utf-8');

$response = [
    'connected' => false,
    'config' => [
        'Host' => DB_HOST,
        'Port' => DB_PORT,
        'Database' => DB_NAME,
        'User' => DB_USER,
        'Prefix' => DB_PREFIX,
    ],
    'table_exists' => false,
    'error' => null
];

try {
    // 检查连接
    if (isset($pdo) && $pdo instanceof PDO) {
        $response['connected'] = true;
        
        // 检查表是否存在
        try {
            $checkSql = "SHOW TABLES LIKE '" . DB_PREFIX . "vod'";
            $stmt = $pdo->query($checkSql);
            $response['table_exists'] = $stmt->rowCount() > 0;
        } catch (Exception $e) {
            $response['error'] = "表检查失败: " . $e->getMessage();
        }
    } else {
        $response['error'] = 'PDO对象未初始化';
    }
} catch (Exception $e) {
    $response['error'] = $e->getMessage();
}

echo json_encode($response, JSON_UNESCAPED_UNICODE);
?>
