<?php
/**
 * 日志查看接口
 */

require_once dirname(__FILE__) . '/../config.php';

header('Content-Type: application/json; charset=utf-8');

$logFile = LOG_PATH . date('Y-m-d') . '.log';
$logs = [];

if (file_exists($logFile)) {
    $content = file_get_contents($logFile);
    $lines = array_filter(explode("\n", $content));
    // 获取最后20行
    $logs = array_slice($lines, -20);
    // 反转显示最新的在前
    $logs = array_reverse($logs);
}

echo json_encode(['logs' => $logs], JSON_UNESCAPED_UNICODE);
?>
