<?php
/**
 * 视频去重助手 - 配置文件
 * 自动从苹果CMS配置中读取数据库信息
 * @version 1.1.0
 */

// 程序配置
define('APP_NAME', '视频去重助手');
define('APP_VERSION', '1.1.0');
define('APP_DEBUG', true);
define('ROOT_PATH', dirname(__FILE__));
define('LOG_PATH', ROOT_PATH . '/logs/');
define('BACKUP_PATH', ROOT_PATH . '/backup/');

// 日志配置
if (!is_dir(LOG_PATH)) {
    @mkdir(LOG_PATH, 0777, true);
}
if (!is_dir(BACKUP_PATH)) {
    @mkdir(BACKUP_PATH, 0777, true);
}

/**
 * 自动获取数据库配置
 */
function loadDatabaseConfig()
{
    // 获取苹果CMS根目录
    $cmsRoot = dirname(dirname(__FILE__));
    
    // 可能的配置文件位置列表
    $configPaths = [
        $cmsRoot . '/application/database.php',           // 苹果CMS V10标准位置
        $cmsRoot . '/application/config/database.php',
        $cmsRoot . '/config/database.php',
        $cmsRoot . '/app/config/database.php',
        $cmsRoot . '/config.php',
    ];

    $config = [];

    // 尝试从配置文件加载
    foreach ($configPaths as $path) {
        if (file_exists($path)) {
            $fileConfig = require $path;
            
            if (is_array($fileConfig)) {
                // ThinkPHP 5.x 配置格式
                if (isset($fileConfig['default'])) {
                    $dbConfig = $fileConfig['default'];
                } elseif (isset($fileConfig['hostname'])) {
                    // 旧格式
                    $dbConfig = $fileConfig;
                } else {
                    // 寻找 mysql 配置
                    $dbConfig = reset($fileConfig);
                }

                if (isset($dbConfig['hostname']) || isset($dbConfig['host'])) {
                    $config = $dbConfig;
                    break;
                }
            }
        }
    }

    // 如果没找到配置，尝试从环境变量或.env文件
    if (empty($config)) {
        $envFile = $cmsRoot . '/.env';
        if (file_exists($envFile)) {
            $env = parse_ini_file($envFile);
            if (isset($env['DB_HOST'])) {
                $config = [
                    'hostname' => $env['DB_HOST'] ?? 'localhost',
                    'database' => $env['DB_NAME'] ?? 'maccms',
                    'username' => $env['DB_USER'] ?? 'root',
                    'password' => $env['DB_PASSWORD'] ?? '',
                    'hostport' => $env['DB_PORT'] ?? 3306,
                ];
            }
        }
    }

    // 设置数据库常量
    define('DB_HOST', $config['hostname'] ?? $config['host'] ?? 'localhost');
    define('DB_USER', $config['username'] ?? $config['user'] ?? 'root');
    define('DB_PASS', $config['password'] ?? '');
    define('DB_NAME', $config['database'] ?? 'maccms');
    define('DB_PORT', $config['hostport'] ?? $config['port'] ?? 3306);
    define('DB_PREFIX', $config['prefix'] ?? 'mac_');

    return [
        'host' => DB_HOST,
        'user' => DB_USER,
        'pass' => DB_PASS,
        'name' => DB_NAME,
        'port' => DB_PORT,
        'prefix' => DB_PREFIX,
    ];
}

// 加载数据库配置
loadDatabaseConfig();

// PDO连接配置
try {
    $pdo = new PDO(
        'mysql:host=' . DB_HOST . ';port=' . DB_PORT . ';dbname=' . DB_NAME,
        DB_USER,
        DB_PASS,
        [PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION]
    );
    $pdo->exec('SET NAMES utf8mb4');
} catch (Exception $e) {
    die('数据库连接失败: ' . $e->getMessage() . 
        '<br/>检查配置: Host=' . DB_HOST . 
        ', User=' . DB_USER . 
        ', Database=' . DB_NAME);
}

// 返回PDO对象
return $pdo;
?>
