<?php

namespace addons\appfox;

use think\Addons;

class Appfox extends Addons
{
    /**
     * 安装方法
     * @return bool
     */
    public function install()
    {

        if (file_exists("application/admin/controller/Appfox.php")) {
            return true;
        }
        $this->recurse_copy("addons/appfox/src/appfox/", "application/admin/view/appfox/");
        // 检查并复制view_new文件夹（如果存在）到指定路径
      $directory = 'application/admin/admin/view_new/appfox/';

if (!is_dir($directory)) {
            // 目标路径修改为 application/admin/view_new/appfox/
            $this->recurse_copy("addons/appfox/src/appfox/", "application/admin/view_new/appfox/");
        }
        copy('addons/appfox/src/Appfox.php', "application/admin/controller/Appfox.php");
        $this->recurse_copy("addons/appfox/src/appfoxapi/Appfox.php", "application/api/controller/Appfox.php");
        $this->recurse_copy("addons/appfox/src/appfoxapi/Appfoxs.php", "application/api/controller/Appfoxs.php");
//		copy('addons/appfox/src/Encrypt.php', "application/api/controller/Encrypt.php");

        $path = 'application/data/config/quickmenu.txt';
        $appfox = @require('application/extra/maccms.php');
        $info = 'APPFOX管理,' . $appfox['site']['install_dir'] . 'addons/appfox/index.php';
        if (stristr(file_get_contents($path), $info))
            return true;
        elseif (file_put_contents($path, chr(13) . chr(10) . $info, FILE_APPEND))
            return true;
        return true;
    }

    /**
     * 卸载方法
     * @return bool
     */
//	public function uninstall()
//	{
//		//调用函数，传入路径
//		$this->deldir('application/admin/view/appfox');
//		unlink('application/admin/controller/Appfox.php');
//		unlink('application/api/controller/App.php');
//		unlink('application/api/controller/Encrypt.php');
//		unlink('application/admin/view/appfox');
//
//		$path = 'application/data/config/quickmenu.txt';
//		$appfox = @require('application/extra/maccms.php');
//		$info = 'APPFOX管理,' . $appfox['site']['install_dir'] . 'addons/appfox/index.php';
//		$content = str_replace(chr(13) . chr(10) . $info, '', file_get_contents($path));
//		file_put_contents($path, $content);
//		$config_menu = config('quickmenu');
//		if (!empty($config_menu)) {
//			$quickmenu = array_values($config_menu);
//			$quickmenu = join(chr(13),$quickmenu);
//			$quickmenu = str_replace($info, '', $quickmenu);
//			$quickmenu = str_replace(chr(10),'',$quickmenu);
//            $menu_arr = explode(chr(13),$quickmenu);
//			mac_arr2file(APP_PATH . 'extra/quickmenu.php', $menu_arr);
//		}
//		return true;
//	}


    /**
     * 卸载方法
     * @return bool 卸载成功返回true，失败返回false
     */
    public function uninstall()
    {
        $log = [];
        $success = true;

        // 删除视图目录
        try {
            if (is_dir('application/admin/view_new/appfox')) {
                $this->deldir('application/admin/view_new/appfox');
            }
            if (is_dir('application/admin/view/appfox')) {
                $this->deldir('application/admin/view/appfox');
                $log[] = '成功删除视图目录: application/admin/view/appfox';
            } else {
                $log[] = '视图目录不存在，跳过删除: application/admin/view/appfox';
            }
        } catch (\Exception $e) {
            $log[] = '删除视图目录失败: ' . $e->getMessage();
            $success = false;
        }

        // 删除控制器文件
        $controllerFiles = [
            'application/admin/controller/Appfox.php',
            'application/api/controller/Appfox.php', // 修正为安装时实际复制的文件
              'application/api/controller/Appfoxs.php',
            // 'application/api/controller/Encrypt.php', // 安装时被注释，不删除
        ];

        foreach ($controllerFiles as $file) {
            try {
                if (file_exists($file)) {
                    unlink($file);
                    $log[] = '成功删除控制器: ' . $file;
                } else {
                    $log[] = '控制器不存在，跳过删除: ' . $file;
                }
            } catch (\Exception $e) {
                $log[] = '删除控制器失败: ' . $file . ' - ' . $e->getMessage();
                $success = false;
            }
        }

        // 移除菜单配置
        try {
            $path = 'application/data/config/quickmenu.txt';
            $appfox = @require('application/extra/maccms.php');
            $info = 'APPFOX管理,' . $appfox['site']['install_dir'] . 'addons/appfox/index.php';

            if (file_exists($path)) {
                $content = file_get_contents($path);
                $newContent = str_replace(chr(13) . chr(10) . $info, '', $content);

                if ($newContent !== $content) {
                    file_put_contents($path, $newContent);
                    $log[] = '成功从quickmenu.txt中移除菜单项';
                } else {
                    $log[] = '菜单项不存在于quickmenu.txt中，跳过移除';
                }
            } else {
                $log[] = 'quickmenu.txt文件不存在，跳过移除菜单项';
            }
        } catch (\Exception $e) {
            $log[] = '移除菜单项失败: ' . $e->getMessage();
            $success = false;
        }
        // 记录卸载日志
        $this->logUninstall($log);
        return $success;
    }

    /**
     * 记录卸载日志
     * @param array $log 日志内容数组
     */
    private function logUninstall($log)
    {
        $logContent = "[" . date('Y-m-d H:i:s') . "] 卸载操作日志:\n";
        $logContent .= implode("\n", $log) . "\n\n";

        $logFile = 'application/logs/appfox_uninstall.log';
        file_put_contents($logFile, $logContent, FILE_APPEND);
    }


    function deldir($dir)
    {
        //先删除目录下的文件：
        $dh = opendir($dir);
        while ($file = readdir($dh)) {
            if ($file != "." && $file != "..") {
                $fullpath = $dir . "/" . $file;
                if (!is_dir($fullpath)) {
                    unlink($fullpath);
                } else {
                    $this->deldir($fullpath);
                }
            }
        }

        closedir($dh);
        //删除当前文件夹：
        if (rmdir($dir)) {
            return true;
        } else {
            return false;
        }
    }

    function recurse_copy($src, $dst)
    {  // 原目录，复制到的目录

        $dir = opendir($src);
        @mkdir($dst);
        while (false !== ($file = readdir($dir))) {
            if (($file != '.') && ($file != '..')) {
                if (is_dir($src . '/' . $file)) {
                    $this->recurse_copy($src . '/' . $file, $dst . '/' . $file);
                } else {
                    copy($src . '/' . $file, $dst . '/' . $file);
                }
            }
        }
        closedir($dir);
    }
}
