-- 1. APP页面设置表
CREATE TABLE IF NOT EXISTS `app_page_setting` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type_en` varchar(50) NOT NULL COMMENT '分类英文名',
  `type_id` int(11) NOT NULL DEFAULT '0' COMMENT '分类ID，0表示主分类',
  `block_name` varchar(100) DEFAULT NULL COMMENT '板块名称',
  `today_name` varchar(100) DEFAULT NULL COMMENT '今日推荐名称',
  `carousel_recommend` varchar(50) DEFAULT NULL COMMENT '轮播图推荐位',
  `today_recommend` varchar(50) DEFAULT NULL COMMENT '今日推荐位',
  `custom_recommend` varchar(50) DEFAULT NULL COMMENT '自定义推荐位',
  `create_time` int(11) DEFAULT NULL,
  `update_time` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_type` (`type_en`,`type_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COMMENT='APP页面设置表';

-- 2. 广告配置表
CREATE TABLE IF NOT EXISTS `appfox_advert_config` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `ad_splash_status` tinyint(1) DEFAULT '0' COMMENT '开屏广告状态',
  `ad_history_feed_status` tinyint(1) DEFAULT '0' COMMENT '历史信息流广告状态',
  `ad_home_page_insert_status` tinyint(1) DEFAULT '0' COMMENT '首页插屏广告状态',
  `ad_search_page_banner_status` tinyint(1) DEFAULT '0' COMMENT '搜索页banner广告状态',
  `ad_home_banner_status` tinyint(1) DEFAULT '0' COMMENT '首页banner广告状态',
  `ad_search_feed_status` tinyint(1) DEFAULT '0' COMMENT '搜索页结果信息流状态',
  `ad_rank_feed_status` tinyint(1) DEFAULT '0' COMMENT '排行信息流广告状态',
  `ad_mine_page_banner_status` tinyint(1) DEFAULT '0' COMMENT '我的页面banner广告状态',
  `ad_play_feed_status` tinyint(1) DEFAULT '0' COMMENT '播放信息流广告状态',
  `ad_detail_page_banner_status` tinyint(1) DEFAULT '0' COMMENT '播放页banner广告状态',
  `enablePlayerRewarded` tinyint(1) NOT NULL DEFAULT '0' COMMENT '进入播放自动启动激励视频',
  `detailstatus` tinyint(1) NOT NULL DEFAULT '0' COMMENT '播放页面插屏',
  `create_time` int(11) DEFAULT NULL COMMENT '创建时间',
  `update_time` int(11) DEFAULT NULL COMMENT '更新时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='广告配置表';

-- 3. 系统配置表
CREATE TABLE IF NOT EXISTS `appfox_config` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL COMMENT '配置名称',
  `value` text COMMENT '配置值',
  `group` varchar(20) DEFAULT 'base' COMMENT '配置分组',
  `remark` varchar(100) DEFAULT NULL COMMENT '备注',
  `create_time` int(11) DEFAULT NULL COMMENT '创建时间',
  `update_time` int(11) DEFAULT NULL COMMENT '更新时间',
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='系统配置表';

-- 4. 解析配置表
CREATE TABLE IF NOT EXISTS `appfox_parse_config` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `parse_name` varchar(100) NOT NULL COMMENT '解析名称',
  `player_code` varchar(50) NOT NULL COMMENT '播放器编码',
  `parse_url` varchar(255) DEFAULT NULL COMMENT '解析链接',
  `player_type` varchar(50) NOT NULL DEFAULT '' COMMENT '播放器类型',
  `is_direct` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否直链拼接 1是 0否',
  `status` tinyint(1) DEFAULT '1' COMMENT '状态：1启用，0禁用',
  `create_time` int(11) DEFAULT NULL COMMENT '创建时间',
  `update_time` int(11) DEFAULT NULL COMMENT '更新时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='解析配置表';

-- 5. 搜索采集配置表
CREATE TABLE IF NOT EXISTS `appfox_search_collect` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `search_name` varchar(100) NOT NULL COMMENT '搜索名称',
  `search_url` varchar(255) NOT NULL COMMENT '搜索链接',
  `status` tinyint(1) DEFAULT '0' COMMENT '状态：1启用，0禁用',
  `create_time` int(11) DEFAULT NULL COMMENT '创建时间',
  `update_time` int(11) DEFAULT NULL COMMENT '更新时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='搜索采集配置表';

-- 6. 系统配置表(另一张)
CREATE TABLE IF NOT EXISTS `appfox_system_config` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `danmu_settings` text COMMENT '弹幕设置',
  `public_settings` text COMMENT '公共设置',
  `share_text` varchar(255) DEFAULT '' COMMENT '分享文字',
  `bottom_nav` text COMMENT '底部导航栏',
  `shading_layer` text COMMENT '遮罩层',
  `top_order` varchar(255) DEFAULT NULL COMMENT '排行榜排序类型',
  `app_sign` varchar(225) DEFAULT NULL COMMENT 'app_sign',
  `app_key` varchar(225) DEFAULT NULL COMMENT 'app_key',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `update_time` datetime DEFAULT NULL COMMENT '更新时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='系统配置表';

-- 7. 版本管理表
CREATE TABLE IF NOT EXISTS `appfox_version` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `version` varchar(20) NOT NULL COMMENT '版本号',
  `update_url` varchar(255) NOT NULL COMMENT '更新链接',
  `description` text COMMENT '版本描述',
  `is_force` tinyint(1) DEFAULT '0' COMMENT '是否强制更新：1是，0否',
  `create_time` int(11) DEFAULT NULL COMMENT '创建时间',
  `update_time` int(11) DEFAULT NULL COMMENT '更新时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='版本管理表';

-- 留言表

CREATE TABLE IF NOT EXISTS `appfox_gbook` (
  `gbook_id` int(11) NOT NULL AUTO_INCREMENT COMMENT '留言ID',
  `user_id` int(11) DEFAULT '0' COMMENT '用户ID',
  `gbook_name` varchar(50) NOT NULL DEFAULT '' COMMENT '用户名',
  `gbook_content` text NOT NULL COMMENT '留言内容',
  `gbook_time` int(11) NOT NULL DEFAULT '0' COMMENT '留言时间',
  `status` tinyint(1) NOT NULL DEFAULT '1' COMMENT '状态：0-待审核，1-已通过',
  `ip` varchar(50) NOT NULL DEFAULT '' COMMENT 'IP地址',
  `reply_content` text COMMENT '回复内容',
  `reply_time` int(11) DEFAULT '0' COMMENT '回复时间',
  PRIMARY KEY (`gbook_id`),
  KEY `user_id` (`user_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='留言表';


CREATE TABLE `appfox_module` (
   `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'id',
  `nav_id` int(10) NOT NULL COMMENT '分类',
  `module_type` int(11) NOT NULL COMMENT '模块类型',
  `category_id` int(10) NOT NULL COMMENT '模块分类',
  `module_name` varchar(225) NOT NULL COMMENT '模块名称',
  `sort_order` int(10) NOT NULL COMMENT '排序',
  `bind_recommend` int(10) NOT NULL COMMENT '绑定推荐',
  `num` int(33) DEFAULT NULL COMMENT '获取条数',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE `appfox_nav` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'id',
  `name` varchar(225) NOT NULL COMMENT '标题',
  `nav_sort` int(11) DEFAULT '0' COMMENT '排序',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='appfox分类';


