<?php

namespace app\admin\controller;

use Exception;
use think\Db;
use think\Image;

class Appfox extends Base
{
    var $_update_url;
    var $_build_url;
    var $_apk_url;

    var $_version;

    protected $app_custom_icons;

    public function __construct()
    {
        
          $directory = 'application/admin/admin/view_new/appfox/';

if (!is_dir($directory)) {
     // 目标路径修改为 application/admin/view_new/appfox/
            $this->recurse_copy("addons/appfox/src/appfox/", "application/admin/view_new/appfox/");
}
        
        
        
        
        
        
        
        
        
        
        parent::__construct();
        $this->_param = input();
    }

    function getHttp()
    {
        if (isset($_SERVER['HTTPS']) && ('1' == $_SERVER['HTTPS'] || 'on' == strtolower($_SERVER['HTTPS']))) {
            return "https://";
        } elseif (isset($_SERVER['SERVER_PORT']) && ('443' == $_SERVER['SERVER_PORT'])) {
            return "https://";
        }
        return "http://";
    }

    public function index()
    {
        if (!file_exists("./addons/appfox/install.lock")) {
            return $this->fetch('admin@appfox/init');
        }
        return $this->fetch('admin@appfox/index');
    }


    public function install()
{
    //导入sql
    $this->importsql('appfox/app.sql');

    // --- 数据库升级（新增字段检查与添加） ---

    // 1. appfox_system_config 表新增字段
    // 字段 1: shading_layer
    try {
        $fieldExists = Db::query("SHOW COLUMNS FROM `appfox_system_config` LIKE 'shading_layer'");
        if (empty($fieldExists)) {
            // 注意：这里将字段类型从 VARCHAR(255) 修正为 TEXT，以匹配您 SQL 定义中的类型
            Db::execute("ALTER TABLE `appfox_system_config` ADD COLUMN `shading_layer` TEXT COMMENT '遮罩层'");
        }
    } catch (\Exception $e) {
        // 记录日志：新增 shading_layer 字段失败
        // Log::error("新增 shading_layer 字段失败: " . $e->getMessage());
    }

    // 字段 2: app_sign
    try {
        $fieldExists = Db::query("SHOW COLUMNS FROM `appfox_system_config` LIKE 'app_sign'");
        if (empty($fieldExists)) {
            Db::execute("ALTER TABLE `appfox_system_config` ADD COLUMN `app_sign` varchar(225) DEFAULT NULL COMMENT 'app_sign'");
        }
    } catch (\Exception $e) {
        // 记录日志：新增 app_sign 字段失败
    }

    // 字段 3: app_key
    try {
        $fieldExists = Db::query("SHOW COLUMNS FROM `appfox_system_config` LIKE 'app_key'");
        if (empty($fieldExists)) {
            Db::execute("ALTER TABLE `appfox_system_config` ADD COLUMN `app_key` varchar(225) DEFAULT NULL COMMENT 'app_key'");
        }
    } catch (\Exception $e) {
        // 记录日志：新增 app_key 字段失败
    }

    // 字段 4: top_order
    try {
        $fieldExists = Db::query("SHOW COLUMNS FROM `appfox_system_config` LIKE 'top_order'");
        if (empty($fieldExists)) {
            Db::execute("ALTER TABLE `appfox_system_config` ADD COLUMN `top_order` varchar(255) DEFAULT NULL COMMENT '排行榜排序类型'");
        }
    } catch (\Exception $e) {
        // 记录日志：新增 top_order 字段失败
    }
    
    // 2. appfox_advert_config 表新增字段
    // 字段 1: detailstatus
    try {
        $fieldExists = Db::query("SHOW COLUMNS FROM `appfox_advert_config` LIKE 'detailstatus'");
        if (empty($fieldExists)) {
            Db::execute("ALTER TABLE `appfox_advert_config` ADD COLUMN `detailstatus` tinyint(1) NOT NULL DEFAULT '0' COMMENT '播放页面插屏'");
        }
    } catch (\Exception $e) {
        // 记录日志：新增 detailstatus 字段失败
    }


    // 写入安装锁文件
    fwrite(fopen('./addons/appfox/install.lock', 'wb'), 'installed');
    return true;
}

    /**
     * 导入SQL
     *
     * @param string $name 插件名称
     * @return  boolean
     */
    function importsql($name)
    {

        $sqlFile = ADDON_PATH . $name;
        if (is_file($sqlFile)) {
            $lines = file($sqlFile);
            $templine = '';
            foreach ($lines as $line) {
                if (substr($line, 0, 2) == '--' || $line == '' || substr($line, 0, 2) == '/*')
                    continue;

                $templine .= $line;
                if (substr(trim($line), -1, 1) == ';') {
                    $templine = str_ireplace('__PREFIX__', config('database.prefix'), $templine);
                    $templine = str_ireplace('INSERT INTO ', 'INSERT IGNORE INTO ', $templine);
                    try {
                        Db::execute($templine);
                    } catch (Exception $e) {
                        //$e->getMessage();
                    }
                    $templine = '';
                }
            }
        }
        return true;
    }


    public function curlPostData($url, $postData, $connect_timeout = 0, $is_upload = true)
    {
        // 创建cURL资源
        $ch = curl_init();

        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
        curl_setopt($ch, CURLOPT_SSLVERSION, 0);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $postData);
        if ($connect_timeout) {
            curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, $connect_timeout); // 设置连接的最大等待时间为 5 秒
        }

        // 设置其他cURL选项
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

        // 执行cURL请求并获取响应
        $response = curl_exec($ch);

        // 检查请求是否成功
        if ($response === false) {
            if ($is_upload) {
                $this->setErrorMsg("上传文件失败,需本地上传后再打包：" . curl_error($ch));
            } else {
                $this->setErrorMsg("连接到打包服务器失败，请重试或者切换本地或国外服务器打包，再同步接口加密key，" . curl_error($ch));
            }
        }

        // 关闭cURL资源
        curl_close($ch);

        // 返回响应数据
        return $response;
    }


    public function view_player_parse()
    {
        $playerParseList = config("vodplayer");

        // 获取搜索采集开关状态
        $searchEnable = Db::table('appfox_config')
            ->where('name', 'search_collect_enable')
            ->value('value');

        // 获取搜索采集列表
        $searchList = Db::table('appfox_search_collect')
            ->where('status', 1)
            ->order('id', 'desc')
            ->select();

        // 获取解析列表
        $parseList = Db::table('appfox_parse_config')
            ->where('status', 1)
            ->order('id', 'desc')
            ->select();

        // 分配到模板
        $this->assign([
            'search_enable' => $searchEnable ? true : false,
            'search_list' => $searchList,
            'parse_list' => $parseList,
            'player_list' => $playerParseList
        ]);

        return $this->fetch('admin@appfox/player_parse');
    }

    public function save_search_status()
    {
        $enable = input('enable', 0);
        $data = [
            'name' => 'search_collect_enable',
            'value' => $enable,
            'group' => 'collect',
            'update_time' => time()
        ];

        if (Db::table('appfox_config')->where('name', 'search_collect_enable')->find()) {
            Db::table('appfox_config')->where('name', 'search_collect_enable')->update($data);
        } else {
            $data['create_time'] = time();
            Db::table('appfox_config')->insert($data);
        }

        return json(['code' => 0, 'msg' => '保存成功']);
    }

    public function get_search_info()
    {
        $id = input('id', 0);
        $info = Db::table('appfox_search_collect')
            ->where('id', $id)
            ->where('status', 1)
            ->find();

        if ($info) {
            return json(['code' => 0, 'msg' => '获取成功', 'data' => $info]);
        } else {
            return json(['code' => 1, 'msg' => '获取失败']);
        }
    }

    public function add_search()
    {
        $data = [
            'search_name' => input('search_name', ''),
            'search_url' => input('search_url', ''),
            'status' => 1,
            'create_time' => time(),
            'update_time' => time()
        ];

        $id = Db::table('appfox_search_collect')->insertGetId($data);

        if ($id) {
            return json(['code' => 0, 'msg' => '添加成功']);
        } else {
            return json(['code' => 1, 'msg' => '添加失败']);
        }
    }

    public function update_search()
    {
        $id = input('id', 0);
        $data = [
            'search_name' => input('search_name', ''),
            'search_url' => input('search_url', ''),
            'update_time' => time()
        ];

        $result = Db::table('appfox_search_collect')
            ->where('id', $id)
            ->update($data);

        return json(['code' => $result ? 0 : 1, 'msg' => $result ? '修改成功' : '修改失败']);
    }

    public function delete_search()
    {
        $id = input('id', 0);

        $result = Db::table('appfox_search_collect')
            ->where('id', $id)
            ->update(['status' => 0, 'update_time' => time()]);

        return json(['code' => $result ? 0 : 1, 'msg' => $result ? '删除成功' : '删除失败']);
    }

    public function get_parse_info()
    {
        $id = input('id', 0);
        $info = Db::table('appfox_parse_config')
            ->where('id', $id)
            ->where('status', 1)
            ->find();

        if ($info) {
            return json(['code' => 0, 'msg' => '获取成功', 'data' => $info]);
        } else {
            return json(['code' => 1, 'msg' => '获取失败']);
        }
    }

    public function add_parse()
    {
        $data = [
            'parse_name' => input('parse_name', ''),
            'player_type' => input('player_type', ''),
            'player_code' => input('player_code', ''),
            'parse_url' => input('parse_url', ''),
            'is_direct' => input('is_direct', 0),
            'status' => 1,
            'create_time' => time(),
            'update_time' => time()
        ];

        $id = Db::table('appfox_parse_config')->insertGetId($data);

        if ($id) {
            return json(['code' => 0, 'msg' => '添加成功']);
        } else {
            return json(['code' => 1, 'msg' => '添加失败']);
        }
    }

    public function update_parse()
    {
        $id = input('id', 0);
        $data = [
            'parse_name' => input('parse_name', ''),
            'player_type' => input('player_type', ''),
            'player_code' => input('player_code', ''),
            'parse_url' => input('parse_url', ''),
            'is_direct' => input('is_direct', 0),
            'update_time' => time()
        ];

        $result = Db::table('appfox_parse_config')
            ->where('id', $id)
            ->update($data);

        return json(['code' => $result ? 0 : 1, 'msg' => $result ? '修改成功' : '修改失败']);
    }

    public function delete_parse()
    {
        $id = input('id', 0);

        $result = Db::table('appfox_parse_config')
            ->where('id', $id)
            ->update(['status' => 0, 'update_time' => time()]);

        return json(['code' => $result ? 0 : 1, 'msg' => $result ? '删除成功' : '删除失败']);
    }


    //广告配置页面开始


    public function view_advert_config_form()
    {
        // 获取广告配置，如果没有则创建默认配置
        $config = Db::table('appfox_advert_config')->find();
        if (!$config) {
            $defaultData = [
                'create_time' => time(),
                'update_time' => time()
            ];
            Db::table('appfox_advert_config')->insert($defaultData);
            $config = Db::table('appfox_advert_config')->find();
        }

        $this->assign('info', $config);
        return $this->fetch('admin@appfox/advert_config');
    }


    public function save_advert_config_form()
    {
        $data = input('post.');

        // 确保所有开关字段都有值
        $switchFields = [
            'ad_splash_status',
            'ad_history_feed_status',
            'ad_home_page_insert_status',
            'ad_search_page_banner_status',
            'ad_home_banner_status',
            'ad_search_feed_status',
            'ad_rank_feed_status',
            'ad_mine_page_banner_status',
            'ad_play_feed_status',
            'ad_detail_page_banner_status',
            'enablePlayerRewarded',  
            'detailstatus'
            // 新增的字段
        ];

        foreach ($switchFields as $field) {
            if (!isset($data[$field])) {
                $data[$field] = 0;
            } else {
                $data[$field] = $data[$field] ? 1 : 0;
            }
        }

        $data['update_time'] = time();

        // 获取配置ID
        $config = Db::table('appfox_advert_config')->find();

        if ($config) {
            // 更新配置，添加where条件
            $result = Db::table('appfox_advert_config')
                ->where('id', $config['id'])
                ->update($data);

            if ($result !== false) {
                return json(['code' => 0, 'msg' => '保存成功']);
            } else {
                return json(['code' => 1, 'msg' => '保存失败']);
            }
        } else {
            // 如果没有配置记录，则创建新的
            $data['create_time'] = time();
            $result = Db::table('appfox_advert_config')->insert($data);

            if ($result) {
                return json(['code' => 0, 'msg' => '保存成功']);
            } else {
                return json(['code' => 1, 'msg' => '保存失败']);
            }
        }
    }


    //版本管理页面开始


    public function view_version()
    {
        $list = Db::table('appfox_version')
            ->order('create_time', 'desc')
            ->select();

        $this->assign('list', $list);
        return $this->fetch('admin@appfox/version_list');
    }

    // 保存版本
    public function save_version_form()
    {
        $data = input('post.');

        // 验证数据
        if (empty($data['version'])) {
            return json(['code' => 1, 'msg' => '版本号不能为空']);
        }
        if (empty($data['update_url'])) {
            return json(['code' => 1, 'msg' => '更新链接不能为空']);
        }

        // 处理强制更新字段

        $data['update_time'] = time();

        if (empty($data['id'])) {
            // 添加
            $data['create_time'] = time();
            $result = Db::table('appfox_version')->insert($data);
            $msg = '添加成功';
        } else {
            // 编辑
            $result = Db::table('appfox_version')->where('id', $data['id'])->update($data);
            $msg = '更新成功';
        }

        if ($result !== false) {

            return json(['code' => 0, 'msg' => $msg]);
        } else {
            return json(['code' => 1, 'msg' => '操作失败']);
        }
    }

    // 删除版本
    public function delete()
    {
        $id = input('id');

        if (empty($id)) {
            return json(['code' => 1, 'msg' => '参数错误']);
        }

        $result = Db::table('appfox_version')->where('id', $id)->delete();

        if ($result) {

            return json(['code' => 0, 'msg' => '删除成功']);
        } else {
            return json(['code' => 1, 'msg' => '删除失败']);
        }
    }


    public function view_version_form()
    {
        $id = input('id');
        $info = [];

        if ($id) {
            $info = Db::table('appfox_version')->where('id', $id)->find();
            // 确保强制更新状态正确传递
            $info['is_force'] = isset($info['is_force']) ? (int)$info['is_force'] : 0;
        }

        $this->assign('info', $info);
        return $this->fetch('admin@appfox/version_form');
    }


    public function view_system_form()
    {
        // 获取配置，如果没有则创建默认配置
        $config = Db::table('appfox_system_config')->find();
        if (!$config) {
            $defaultData = [
                'create_time' => date('Y-m-d H:i:s'), // 时间戳 → DATETIME 格式
                'update_time' => date('Y-m-d H:i:s')  // 时间戳 → DATETIME 格式
            ];
            Db::table('appfox_system_config')->insert($defaultData);
            $config = Db::table('appfox_system_config')->find();
        }

        $this->assign('config', $config);
        return $this->fetch('admin@appfox/system_form');
    }

    public function view_system_save()
    {
        $data = input('post.');

        // 验证数据
        if (empty($data)) {
            return json(['code' => 1, 'msg' => '提交数据不能为空']);
        }

        $data['update_time'] = date('Y-m-d H:i:s'); // 时间戳 → DATETIME 格式

        // 获取配置ID
        $config = Db::table('appfox_system_config')->find();

        if ($config) {
            // 更新配置
            $result = Db::table('appfox_system_config')
                ->where('id', $config['id'])
                ->update($data);
        } else {
            // 创建新配置
            $data['create_time'] = date('Y-m-d H:i:s'); // 时间戳 → DATETIME 格式
            $result = Db::table('appfox_system_config')->insert($data);
        }

        if ($result !== false) {
            return json(['code' => 0, 'msg' => '保存成功']);
        } else {
            return json(['code' => 1, 'msg' => '保存失败']);
        }
    }

    //意见反馈
    public function view_piece_list()
    {


        return $this->fetch('admin@appfox/piece_list');
    }


    public function view_piece_list1()
    {
        $param = input();
        $param['page'] = intval($param['page']) < 1 ? 1 : $param['page'];
        $param['limit'] = intval($param['limit']) < 1 ? 10 : $param['limit'];

        $where = [];
        if (!empty($param['name'])) {
            $param['name'] = htmlspecialchars(urldecode($param['name']));
            $where['gbook_name'] = ['like', '%' . $param['name'] . '%'];  // 修正字段名从name改为gbook_name
        }

        $order = 'gbook_id desc';

        $res = Db::table('appfox_gbook')->where($where)->order($order)->paginate([
            'list_rows' => $param['limit'],
            'page' => $param['page']
        ]);

        // 确保返回符合规范的数据格式
        return json([
            'code' => 1,  // 成功状态码必须为1
            'msg' => '获取成功',
            'count' => $res->total(),  // 使用total()方法获取总记录数
            'data' => $res->items()    // 使用items()方法获取数据列表
        ]);
    }


    public function view_app_page_setting()
    {

        $list = Db::table('appfox_nav')->order('nav_sort', 'DESC')->select();
        foreach ($list as $key => $value) {
            $list[$key]['module_list'] = Db::table('appfox_module')->where('nav_id', $value['id'])->order('sort_order', 'DESC')->select();

            foreach ($list[$key]['module_list'] as $k => $v) {

                $bind_recommend_name = [
                    '0' => '选择推荐',
                    '9' => '推荐9-幻灯片',
                    '1' => '推荐1',
                    '2' => '推荐2',
                    '3' => '推荐3',
                    '4' => '推荐4',
                    '5' => '推荐5',
                    '6' => '推荐6',
                    '7' => '推荐7',
                    '8' => '推荐8',

                ];

                $module_typename = [
                    '10' => '全部类型',
                    '1' => '轮播图',
                    '2' => '时间轴',
                    '3' => '排期表',
                    '4' => '横向-横图-列表',
                    '5' => '横向-竖图-列表',
                    '6' => '竖向-横图-列表',
                    '7' => '竖向-竖图-列表',
                ];
                if($v['category_id'] == 999){
                    $list[$key]['module_list'][$k]['category_name'] = '全部分类';
                }else{
                    $list[$key]['module_list'][$k]['category_name'] = Db::name('Type')->where('type_id', $v['category_id'])->value('type_name');
                }
                $list[$key]['module_list'][$k]['typename'] = $module_typename[$v['module_type']];
                if($v['module_type'] == 8 || $v['module_type'] == 9 || $v['module_type'] == 10 || $v['module_type'] == 11){
                    switch($v['module_type']){
                        case 8:
                            $list[$key]['module_list'][$k]['typename'] = '日人气';
                            break;
                        case 9:
                            $list[$key]['module_list'][$k]['typename'] = '周人气';
                            break;
                        case 10:
                            $list[$key]['module_list'][$k]['typename'] = '月人气';
                            break;
                        case 11:
                            $list[$key]['module_list'][$k]['typename'] = '总人气';
                            break;
                    }
                }


                if ($v['bind_recommend'] == 9) {
                   $list[$key]['module_list'][$k]['bind_recommend_name'] = '推荐9-幻灯片';
                }else if($v['bind_recommend'] == 51||$v['bind_recommend'] == 52||$v['bind_recommend'] == 53||$v['bind_recommend'] == 54){
                    $type_name = ['日人气', '周人气', '月人气', '总人气'];
                    $list[$key]['module_list'][$k]['bind_recommend_name'] = $type_name[$v['bind_recommend'] - 51];
                }
                 else {
                    $list[$key]['module_list'][$k]['bind_recommend_name'] = '推A荐'.$v['bind_recommend'];
                }
                
               
            }
        }

        // 分配变量到模板
        $this->assign([
            'list' => $list,
            'meta_title' => 'APP页面设置'
        ]);

        return $this->fetch('admin@appfox/app_page_setting');
    }


    public function save_page_setting()
    {
        if (!$this->request->isPost()) {
            return json(['code' => 0, 'msg' => '非法请求']);
        }

        $post = $this->request->post();

        try {
            // 先清空原有设置
            Db::table('app_page_setting')->delete(true);

            $now = time();
            $data = [];

            // 1. 处理主分类设置
            foreach ($post as $key => $value) {
                if (preg_match('/^([a-zA-Z0-9]+)_carousel$/', $key, $matches)) {
                    $type_en = $matches[1];

                    $carouselValue = is_array($value) ? ($value[0] ?? '') : $value;


                    if (!empty($carouselValue)) {
                        $todayValue = $post[$type_en . '_today_recommend'] ?? '';
                        $todayValue = is_array($todayValue) ? ($todayValue[0] ?? '') : $todayValue;

                        // 获取今日推荐名称
                        $todayName = $post[$type_en . '_today_name'] ?? '今日推荐';
                        $todayName = is_array($todayName) ? ($todayName[0] ?? '今日推荐') : $todayName;

                        $data[] = [
                            'type_en' => $type_en,
                            'type_id' => 0,
                            'block_name' => '',
                            'today_name' => $todayName, // 保存今日推荐名称
                            'carousel_recommend' => $carouselValue,
                            'today_recommend' => $todayValue,
                            'custom_recommend' => '',
                            'create_time' => $now,
                            'update_time' => $now
                        ];
                    }
                }
            }

            // 2. 处理自定义板块设置
            foreach ($post as $key => $values) {
                if (preg_match('/^([a-zA-Z0-9]+)_block_name$/', $key, $matches) && is_array($values)) {
                    $type_en = $matches[1];

                    if (!isset($post[$type_en . '_block_recommend'])) {
                        continue;
                    }

                    foreach ($values as $index => $blockName) {
                        if (!empty($blockName)) {
                            $recommend = $post[$type_en . '_block_recommend'][$index] ?? '';

                            $data[] = [
                                'type_en' => $type_en,
                                'type_id' => 1, // 自定义板块标记为1
                                'block_name' => $blockName,
                                'today_name' => '',
                                'carousel_recommend' => '',
                                'today_recommend' => '',
                                'custom_recommend' => $recommend,
                                'create_time' => $now,
                                'update_time' => $now
                            ];
                        }
                    }
                }
            }

            // 批量插入新设置
            if (!empty($data)) {
                Db::table('app_page_setting')->insertAll($data);
                return json(['code' => 1, 'msg' => '保存成功']);
            }

            return json(['code' => 0, 'msg' => '没有有效数据需要保存']);
        } catch (\Exception $e) {
            return json(['code' => 0, 'msg' => '保存失败: ' . $e->getMessage()]);
        }
    }


    public function add_nav()
    {
        $navName = input('navName', '');
        $navSort = input('navSort', 0);

        Db::table('appfox_nav')->insert(['name' => $navName, 'nav_sort' => $navSort]);
        return json(['code' => 1, 'msg' => '新增成功']);
    }

    public function edit_current_nav()
    {
        $id = input('id', 0);
        $navName = input('navName', '');
        $navSort = input('navSort', 0);
        Db::table('appfox_nav')->where('id', $id)->update(['name' => $navName, 'nav_sort' => $navSort]);
        return json(['code' => 1, 'msg' => '编辑成功']);
    }

    public function delete_current_nav()
    {
        $id = input('id', 0);
        Db::table('appfox_nav')->where('id', $id)->delete();
        return json(['code' => 1, 'msg' => '删除成功']);
    }
    public function adds()
    {
        $navId = input('navId', 0);
        // 获取所有分类数据
        $all_type_list = Db::name('Type')
            ->field('*')
            ->order('type_id ASC')
            ->select();

        $this->assign('navId', $navId);
        $this->assign('all_type_list', $all_type_list);
        return $this->fetch('admin@appfox/add_module');
    }

    public function addmodule()
    {
        $data = input('post.');
        Db::table('appfox_module')->insert($data);
        return json(['code' => 1, 'msg' => '新增成功']);
    }

    public function edit_module()
    {
        if ($this->request->isPost()) {
            $data = input('post.');
            Db::table('appfox_module')->where('id', $data['id'])->update($data);
            return json(['code' => 1, 'msg' => '编辑成功']);
        }
      

        // 获取所有分类数据
        $all_type_list = Db::name('Type')
            ->field('*')
            ->order('type_id ASC')
            ->select();
        $id = input('id', 0);
        $data = Db::table('appfox_module')->where('id', $id)->find();
        $this->assign('data', $data);
        $this->assign('all_type_list', $all_type_list);
        return $this->fetch('admin@appfox/edit_module');
    }
    public function delete_module()
    {
        $id = input('id', 0);
        Db::table('appfox_module')->where('id', $id)->delete();
        return json(['code' => 1, 'msg' => '删除成功']);
    }
    
     function recurse_copy($src, $dst)
    {  // 原目录，复制到的目录

        $dir = opendir($src);
        @mkdir($dst);
        while (false !== ($file = readdir($dir))) {
            if (($file != '.') && ($file != '..')) {
                if (is_dir($src . '/' . $file)) {
                    $this->recurse_copy($src . '/' . $file, $dst . '/' . $file);
                } else {
                    copy($src . '/' . $file, $dst . '/' . $file);
                }
            }
        }
        closedir($dir);
    }
}
