<?php

namespace app\api\controller;

use think\Cache;
use think\Db;
use think\Request;
// 【新增】如果直接使用 Redis 类，请确保 PHP 环境安装了 redis 扩展

/**
 * 搜索/视频API接口，集成了客户端安全签名校验
 */
class Appfoxs extends Base
{
    // ============================================================

    // ============================================================
    const APK_FINGERPRINT = 'd619a96ce67d684ad'; 

    const INNER_SALT = 'DefaultSalt_ABC';
    
    // 【必填配置 3：时间戳容忍度】5 分钟 (300,000 毫秒)
    const TIMESTAMP_TOLERANCE_MS = 300000;

    // ============================================================
    // 【必填配置 4：Redis 连接配置】
    // 此配置用于 Nonce 校验，因为需要使用原子性的 SETNX/EX 命令，
    // 必须直接实例化 \Redis 类，故需要明确的连接参数。
    // 如果您使用框架全局配置的 Redis，请保持与框架配置一致。
    // ============================================================
    const REDIS_HOST = '127.0.0.1';
    const REDIS_PORT = 6379;
    const REDIS_PASSWORD = null; // 如果无密码，请保持 null
    const REDIS_DB = 0;
    
    // 静态属性存储 Redis 实例，确保只连接一次（单例）
    private static $redisInstance = null;
    
    // 【新增】用于存储安全校验失败时的具体错误信息
    protected $securityError = '';

    var $_param;
    protected $request; // 明确声明 request 属性

    public function __construct(Request $request)
    {
        parent::__construct();
        // 使用 $this->request 存储请求实例
        $this->request = $request;
        // 获取并清理参数
        $this->_param = $this->request->param('', '', 'trim,urldecode');
    }
    
    /**
     * 【核心】获取 Redis 客户端实例 (单例模式，集成连接逻辑)
     * 用于需要原子性操作的 Nonce 校验
     * @return \Redis|null
     */
    private function getRedisInstance(): ?\Redis
    {
        // 避免重复连接
        if (self::$redisInstance !== null) {
            return self::$redisInstance;
        }

        // 检查 PHP Redis 扩展是否可用
        if (!class_exists('Redis')) {
            // Log::error('PHP Redis extension is not installed.');
            return null;
        }

        try {
            $redis = new \Redis();
            // 注意：连接超时设置为 1.0 秒
            if ($redis->connect(self::REDIS_HOST, self::REDIS_PORT, 1.0) === false) {
                // Log::error("Redis Connection Failed: Cannot connect.");
                return null;
            }

            // 认证
            if (self::REDIS_PASSWORD !== null) {
                if ($redis->auth(self::REDIS_PASSWORD) === false) {
                    // Log::error("Redis Connection Failed: Authentication failed.");
                    return null;
                }
            }
            
            // 选择 DB
            $redis->select(self::REDIS_DB);
            
            // PING 校验
            $redis->ping();
            
            self::$redisInstance = $redis;
            return self::$redisInstance;

        } catch (\RedisException $e) {
            // Log::error("Redis Connection Failed: " . $e->getMessage());
            echo "❌ Redis 异常：" . $e->getMessage() . "\n";
            return null;
        }
    }
    const HOST = '127.0.0.1';
    const PORT = 6379;
    const PASSWORD = null;
    const DB = 0;

    public  function getConnection()
    {   
    // 避免重复连接
        if (self::$redisInstance !== null) {
            return self::$redisInstance;
        }

    if (!extension_loaded('redis')) {
    echo "Redis 扩展未安装\n";
    return null;
}

if (!class_exists('Redis')) {
    echo "Redis 类不可用\n";
    return null;
}


        try {
            $redis = new \Redis();
            // 注意：连接超时设置为 1.0 秒
            if ($redis->connect(self::REDIS_HOST, self::REDIS_PORT, 1.0) === false) {
                // Log::error("Redis Connection Failed: Cannot connect.");
                echo "1";
                return null;
            }

            // 认证
            if (self::REDIS_PASSWORD !== null) {
                if ($redis->auth(self::REDIS_PASSWORD) === false) {
                    // Log::error("Redis Connection Failed: Authentication failed.");
                       echo "2";
                    return null;
                }
            }
            
            // 选择 DB
            $redis->select(self::REDIS_DB);
            
            // PING 校验
            $redis->ping();
            
            self::$redisInstance = $redis;
            return self::$redisInstance;

        } catch (\RedisException $e) {
            // Log::error("Redis Connection Failed: " . $e->getMessage());
            echo "❌ Redis 异常：" . $e->getMessage() . "\n";
            return null;
        }
    
}
    /**
     * 服务器端签名校验核心方法
     * 客户端需在 header 传递 X-Security-Auth: timestamp|nonce|sign
     * @return bool
     */
    protected function checkSecuritySignature()
    {
        // 1. 获取请求头中的安全认证信息
        $authHeader = $this->request->header('X-Security-Auth');

        if (empty($authHeader)) {
            $this->securityError = 'Missing security authentication header.';
            // Log::error('Security Check: Missing Auth Header');
            return false;
        }

        $parts = explode('|', $authHeader);
        if (count($parts) !== 3) {
            $this->securityError = 'Invalid authentication header format.';
            // Log::error('Security Check: Invalid Auth Header format');
            return false;
        }

        list($timestamp, $nonce, $clientSign) = $parts;

        // 2. 校验时间戳 (防重放)
        $currentTimeMs = round(microtime(true) * 1000);
        
        // 确保时间戳是数字且在有效范围内 (5分钟容忍度)
        if (!is_numeric($timestamp) || abs($currentTimeMs - (int)$timestamp) > self::TIMESTAMP_TOLERANCE_MS) {
            $diffSeconds = round(abs($currentTimeMs - (int)$timestamp) / 1000);
            $this->securityError = "Timestamp out of range ({$diffSeconds}s difference).";
            // Log::error('Security Check: Timestamp expired or future request.');
            return false;
        }

        // 3. 校验 Nonce (使用直接 Redis 连接进行原子性校验)
        $nonceKey = 'security_nonce_' . $nonce;
        // Nonce 的过期时间等于时间戳的容忍度
        $expirySeconds = self::TIMESTAMP_TOLERANCE_MS / 1000;
        
        $redis = $this->getRedisInstance();
        
        if ($redis === null) {
            // Redis 连接失败，出于安全考虑，应拒绝请求
            $this->securityError = 'Server security check failed (Redis connection error).';
            // Log::error('Security Check: Redis instance not available for Nonce check. Failing safe.');
            return false;
        }
        
        // 使用 SETNX (Set if Not eXist) 进行原子性检查和设置
        // 只有当键不存在时才设置成功（$result === true/1）
        $result = $redis->set($nonceKey, 1, ['nx', 'ex' => $expirySeconds]);
        
        // 如果 $result 为 false (代表设置失败)，意味着键已存在 (Nonce 重复使用) 或操作失败
        if ($result === false) {
            $this->securityError = 'Nonce reused (Possible replay attack).';
            // Log::error('Security Check: Nonce reused or SETNX operation failed.');
            return false;
        }
        // --- End Direct Redis Check ---


        // 4. 获取原始请求体 (Body)
        // 客户端 NDK 是对 raw body 进行 MD5 运算的
        $rawBody = $this->request->getContent();
        
        // 如果是 GET 请求，body 默认为空字符串 ""
        $body = $rawBody === false ? '' : $rawBody;


        $config = self::getSystemConfig();

       // 2. 提取字段
         $appSign = isset($config['app_sign']) ? trim($config['app_sign']) : '';
        $appKey  = isset($config['app_key']) ? trim($config['app_key']) : '';

    // 3. 判断是否为空
         if ($appSign === '') {
            $this->securityError = '请到管理端<其他设置>页面 填写必要信息！';
               return false;
          }

         if ($appKey === '') {
              $this->securityError = '请到管理端<其他设置>页面 填写必要信息！';
              return false;
           }

        $rawString = $appSign . $appKey . $timestamp . $nonce . $body;
        

        // 【调试】打印原始字符串，用于排查客户端与服务器端差异
        // Log::debug("Server Raw String: " . $rawString);

        // 6. 计算服务器端签名
        $serverSign = md5($rawString);

        // 7. 校验签名 (不区分大小写比较)
        if (strcasecmp($serverSign, $clientSign) === 0) {
            return true;
        } else {
            $this->securityError = 'Signature mismatch.';
            // Log::error('Security Check: Signature mismatch. Client: ' . $clientSign . ' Server ' . $serverSign);
            return false;
        }
    }
/**
     * 【新增】AES-128-CBC 加密响应数据
     * @param string $data 原始 JSON 字符串
     * @return string Base64编码后的加密字符串
     */
    private function encryptResponseData($data)
    {
        try {
            // 获取系统配置中的 Key 和 Sign
            $config = self::getSystemConfig();
            $appKey = isset($config['app_key']) ? trim($config['app_key']) : '1234567890123456';
            
            // =======================================================
            // 密钥处理策略：
            // AES-128 需要 16 字节密钥。
            // 这里截取 app_key 的前16位，不足则补0，确保长度正确
            // =======================================================
            $key = substr(str_pad(md5($appKey), 16, '0'), 0, 16);
            
            // IV (初始化向量) 策略：
            // 为了客户端方便解密，这里暂时使用 Key 倒序的前16位作为 IV
            // (生产环境建议随机生成IV并拼接到密文中，但为了对接简单，此处固定)
            $iv = strrev($key); 

            // 执行加密
            $encrypted = openssl_encrypt($data, 'AES-128-CBC', $key, OPENSSL_RAW_DATA, $iv);
            
            // 返回 Base64 字符串
            return base64_encode($encrypted);

        } catch (\Exception $e) {
            // Log::error('Encryption failed: ' . $e->getMessage());
            return $data; // 降级处理：如果加密失败，返回原数据（或者抛出错误）
        }
    }

    public function vod()
    {
        // =======================================================
        // 【新增安全校验】在业务逻辑开始前执行签名验证
        // =======================================================
        if (!$this->checkSecuritySignature()) {
              // 返回具体的错误信息
              $errorMsg = empty($this->securityError) ? 'Unknown security check failed.' : $this->securityError;
              // 错误信息中包含了具体的失败原因
              return json(['code' => 403, 'msg' => 'Security Check Failed: ' . $errorMsg], 403);
        }
        // =======================================================

        if ($GLOBALS['config']['api']['vod']['charge'] == 1) {
            $h = $_SERVER['REMOTE_ADDR'];
            if (!$h) {
                echo lang('api/auth_err');
                exit;
            } else {
                $auth = $GLOBALS['config']['api']['vod']['auth'];
                $this->checkDomainAuth($auth);
            }
        }

        $cache_time = intval($GLOBALS['config']['api']['vod']['cachetime']);
        $cach_name = $GLOBALS['config']['app']['cache_flag'] . '_' . 'api_vod_' . md5(http_build_query($this->_param));
        
        // 这里的 Cache::get/set 使用的是框架配置文件中定义的缓存连接，无需额外配置。
        $html = Cache::get($cach_name); 
        
        if (empty($html) || $cache_time == 0) {
            $where = [];
            if (!empty($this->_param['ids'])) {
                $where['vod_id'] = ['in', $this->_param['ids']];
            }
            if (!empty($GLOBALS['config']['api']['vod']['typefilter'])) {
                $where['type_id'] = ['in', $GLOBALS['config']['api']['vod']['typefilter']];
            }

            if (!empty($this->_param['t'])) {
                if (empty($GLOBALS['config']['api']['vod']['typefilter']) || strpos($GLOBALS['config']['api']['vod']['typefilter'], $this->_param['t']) !== false) {
                    $where['type_id'] = $this->_param['t'];
                }
            }
            if (isset($this->_param['isend'])) {
                $where['vod_isend'] = $this->_param['isend'] == 1 ? 1 : 0;
            }
            if (!empty($this->_param['h'])) {
                $todaydate = date('Y-m-d', strtotime('+1 days'));
                $tommdate = date('Y-m-d H:i:s', strtotime('-' . $this->_param['h'] . ' hours'));

                $todayunix = strtotime($todaydate);
                $tommunix = strtotime($tommdate);

                $where['vod_time'] = [['gt', $tommunix], ['lt', $todayunix]];
            }
            if (!empty($this->_param['wd'])) {
                $where['vod_name'] = ['like', '%' . $this->_param['wd'] . '%'];
            }
            if (!empty($this->_param['year'])) {
                $param_year = trim($this->_param['year']);
                if (strlen($param_year) == 4) {
                    $year = intval($param_year);
                } elseif (strlen($param_year) == 9) {
                    $start = (int)substr($param_year, 0, 4);
                    $end = (int)substr($param_year, 5, 4);
                    if ($start > $end) {
                        $tmp_num = $end;
                        $end = $start;
                        $start = $tmp_num;
                    }
                    $tmp_arr = [];
                    $start = max($start, 1900);
                    $end = min($end, date('Y') + 3);
                    for ($i = $start; $i <= $end; $i++) {
                        $tmp_arr[] = $i;
                    }
                    $year = join(',', $tmp_arr);
                }
                $where['vod_year'] = ['in', explode(',', $year)];
            }
            if (empty($GLOBALS['config']['api']['vod']['from']) && !empty($this->_param['from']) && strlen($this->_param['from']) >= 2) {
                $GLOBALS['config']['api']['vod']['from'] = $this->_param['from'];
            }
            if (!empty($GLOBALS['config']['api']['vod']['from'])) {
                $vod_play_from_list = explode(',', trim($GLOBALS['config']['api']['vod']['from']));
                $vod_play_from_list = array_unique($vod_play_from_list);
                $vod_play_from_list = array_filter($vod_play_from_list);
                if (!empty($vod_play_from_list)) {
                    $where['vod_play_from'] = ['or'];
                    foreach ($vod_play_from_list as $vod_play_from) {
                        array_unshift($where['vod_play_from'], ['like', '%' . trim($vod_play_from) . '%']);
                    }
                }
            }
            if (!empty($GLOBALS['config']['api']['vod']['datafilter'])) {
                $where['_string'] .= ' ' . $GLOBALS['config']['api']['vod']['datafilter'];
            }
            if (empty($this->_param['pg'])) {
                $this->_param['pg'] = 1;
            }
            $pagesize = $GLOBALS['config']['api']['vod']['pagesize'];
            if (!empty($this->_param['pagesize']) && $this->_param['pagesize'] > 0) {
                $pagesize = min((int)$this->_param['pagesize'], 100);
            }

            $sort_direction = !empty($this->_param['sort_direction']) && $this->_param['sort_direction'] == 'asc' ? 'asc' : 'desc';
            $order = 'vod_time ' . $sort_direction;
            $field = 'vod_id,vod_name,type_id,"" as type_name,vod_en,vod_time,vod_remarks,vod_play_from,vod_time';

            if ($this->_param['ac'] == 'videolist' || $this->_param['ac'] == 'detail') {
                $field = '*';
            }
            $res = model('vod')->listData($where, $order, $this->_param['pg'], $pagesize, 0, $field, 0);


            // =========================================
            $playerConfig = config('vodplayer');
            $enabledPlayers = [];

            // 1. 重构播放器数据
            foreach ($playerConfig as $code => $info) {
                if (isset($info['status']) && $info['status'] == 1) {
                    $sort = isset($info['sort']) && is_numeric($info['sort'])
                        ? (int)$info['sort']
                        : 0;
                    $enabledPlayers[$code] = [
                        'sort' => $sort,
                        'config' => $info
                    ];
                }
            }

            // 2. 修改为按sort值降序排序（数值大的在前）
            uasort($enabledPlayers, function ($a, $b) {
                // 改为降序排序：$b先减$a
                if ($a['sort'] != $b['sort']) {
                    return $b['sort'] <=> $a['sort']; // 改为降序排序
                }
                return 0;
            });

            // 3. 提取排序后的播放器编码（现在最大的sort值在最前面）
            $sortedPlayerCodes = array_keys($enabledPlayers);

            // 4. 重构视频数据中的播放源（以下保持不变）
            if (!empty($res['list']) && !empty($sortedPlayerCodes)) {
                foreach ($res['list'] as &$item) {
                    $playSources = [];

                    if (!empty($item['vod_play_from'])) {
                        $froms = explode('$$$', $item['vod_play_from']);
                        $urls = !empty($item['vod_play_url']) ? explode('$$$', $item['vod_play_url']) : [];

                        for ($i = 0; $i < count($froms); $i++) {
                            $code = $froms[$i];
                            $playSources[$code] = $urls[$i] ?? '';
                        }
                    }

                    $orderedFroms = [];
                    $orderedUrls = [];

                    // 现在最大值的播放器会最先被处理
                    foreach ($sortedPlayerCodes as $playerCode) {
                        if (isset($playSources[$playerCode])) {
                            $orderedFroms[] = $playerCode;
                            $orderedUrls[] = $playSources[$playerCode];
                            unset($playSources[$playerCode]);
                        }
                    }

                    // 添加不在配置中的播放源（按原始顺序）
                    foreach ($playSources as $code => $url) {
                        $orderedFroms[] = $code;
                        $orderedUrls[] = $url;
                    }

                    $item['vod_play_from'] = implode('$$$', $orderedFroms);
                    $item['vod_play_url'] = implode('$$$', $orderedUrls);
                    // ================= 新增：评论数量 =================
                    $comment_count = Db::name('comment')
                        ->where([
                            'comment_mid' => 1,
                            'comment_status' => 1,
                            'comment_rid' => $item['vod_id']
                        ])
                        ->count();
                    $item['comment_count'] = $comment_count;
                    // ==================================================
                }
                unset($item);
            }
            // ==========================================

            if ($this->_param['at'] == 'xml') {
                $html = $this->vod_xml($res);
            } else {
                $html = json_encode($this->vod_json($res), JSON_UNESCAPED_UNICODE);
            }
            if ($cache_time > 0) {
                // 缓存存储使用框架的 Cache::set
                Cache::set($cach_name, $html, $cache_time);
            }
        }
        if (
            isset($this->_param['ac']) && $this->_param['ac'] == 'detail' &&
            !empty($this->_param['ids']) && (int)$this->_param['ids'] == $this->_param['ids'] &&
            !empty($GLOBALS['config']['api']['vod']['detail_inc_hits'])
        ) {
            model('Vod')->fieldData(['vod_id' => (int)$this->_param['ids']], ['vod_hits' => ['inc', 1]]);
        }
        if ($this->_param['at'] != 'xml') {
            $html = $this->encryptResponseData($html);
        }
        echo $html;
        exit;
    }
    
    // ... (vod_json, Config, gettets 方法保持不变，请使用您文件中的完整内容) ...
    
    public function vod_json($res)
    {
        $type_list = model('Type')->getCache('type_list');
        foreach ($res['list'] as $k => &$v) {
            $type_info = $type_list[$v['type_id']];
            $v['type_name'] = $type_info['type_name'];
            $v['vod_time'] = date('Y-m-d H:i:s', $v['vod_time']);

            if (substr($v["vod_pic"], 0, 4) == "mac:") {
                $v["vod_pic"] = str_replace('mac:', $this->getImgUrlProtocol('vod'), $v["vod_pic"]);
            } elseif (!empty($v["vod_pic"]) && substr($v["vod_pic"], 0, 4) != "http" && substr($v["vod_pic"], 0, 2) != "//") {
                $v["vod_pic"] = $GLOBALS['config']['api']['vod']['imgurl'] . $v["vod_pic"];
            }

            if ($this->_param['ac'] == 'videolist' || $this->_param['ac'] == 'detail') {
                // 如果指定返回播放组，则只返回对应播放组的播放数据
                // https://github.com/magicblack/maccms10/issues/957
                if (!empty($GLOBALS['config']['api']['vod']['from'])) {
                    // 准备数据，逐个处理
                    $arr_from = explode('$$$', $v['vod_play_from']);
                    $arr_url = explode('$$$', $v['vod_play_url']);
                    $arr_server = explode('$$$', $v['vod_play_server']);
                    $arr_note = explode('$$$', $v['vod_play_note']);
                    $vod_play_from_list = explode(',', trim($GLOBALS['config']['api']['vod']['from']));
                    $vod_play_from_list = array_unique($vod_play_from_list);
                    $vod_play_from_list = array_filter($vod_play_from_list);
                    foreach ($vod_play_from_list as $vod_play_from_index => $vod_play_from) {
                        $key = array_search($vod_play_from, $arr_from);
                        if ($key === false) {
                            unset($vod_play_from_list[$vod_play_from_index]);
                            continue;
                        }
                        $vod_play_url_list[] = $arr_url[$key];
                        $vod_play_server_list[] = $arr_server[$key];
                        $vod_play_note_list[] = $arr_note[$key];
                    }
                    $res['list'][$k]['vod_play_from'] = join(',', $vod_play_from_list);
                    $res['list'][$k]['vod_play_url'] = join('$$$', $vod_play_url_list);
                    $res['list'][$k]['vod_play_server'] = join('$$$', $vod_play_server_list);
                    $res['list'][$k]['vod_play_note'] = join('$$$', $vod_play_note_list);
                }
            } else {
                if (!empty($GLOBALS['config']['api']['vod']['from'])) {
                    // 准备数据，逐个处理
                    $arr_from = explode('$$$', $v['vod_play_from']);
                    $vod_play_from_list = explode(',', trim($GLOBALS['config']['api']['vod']['from']));
                    $vod_play_from_list = array_unique($vod_play_from_list);
                    $vod_play_from_list = array_filter($vod_play_from_list);
                    foreach ($vod_play_from_list as $vod_play_from_index => $vod_play_from) {
                        $key = array_search($vod_play_from, $arr_from);
                        if ($key === false) {
                            unset($vod_play_from_list[$vod_play_from_index]);
                            continue;
                        }
                    }
                    $res['list'][$k]['vod_play_from'] = join(',', $vod_play_from_list);
                } else {
                    $res['list'][$k]['vod_play_from'] = str_replace('$$$', ',', $v['vod_play_from']);
                }
            }
        }


        if ($this->_param['ac'] != 'videolist' && $this->_param['ac'] != 'detail') {
            $class = [];
            $typefilter = explode(',', $GLOBALS['config']['api']['vod']['typefilter']);

            foreach ($type_list as $k => &$v) {

                if (!empty($GLOBALS['config']['api']['vod']['typefilter'])) {
                    if (in_array($v['type_id'], $typefilter)) {
                        $class[] = ['type_id' => $v['type_id'], 'type_pid' => $v['type_pid'], 'type_name' => $v['type_name']];
                    }
                } else {
                    $class[] = ['type_id' => $v['type_id'], 'type_pid' => $v['type_pid'], 'type_name' => $v['type_name']];
                }
            }
            $res['class'] = $class;
        }
        return $res;
    }
    
    public function gettets(){
        return "cessss";
    }

    public function Config()
    {
        if (!$this->checkSecuritySignature()) {
              // 返回具体的错误信息
              $errorMsg = empty($this->securityError) ? 'Unknown security check failed.' : $this->securityError;
              // 错误信息中包含了具体的失败原因
              return json(['code' => 403, 'msg' => 'Security Check Failed: ' . $errorMsg], 403);
        }
        // 1. 获取广告配置
        $adConfig = Db::table('appfox_advert_config')->find();

        // 2. 获取系统配置
        $systemConfig = Db::table('appfox_system_config')->find();

        // 3. 获取搜索采集配置
        $searchEnable = Db::table('appfox_config')
            ->where('name', 'search_collect_enable')
            ->value('value');

        $searchList = Db::table('appfox_search_collect')
            ->where('status', 1)
            ->order('id', 'desc')
            ->select();

        // 4. 获取解析配置
        $parseList = Db::table('appfox_parse_config')
            ->where('status', 1)
            ->order('id', 'desc')
            ->select();

        // 5. 获取播放器列表配置
        $playerParseList = config("vodplayer");
        $playerList = [];
        foreach ($playerParseList as $playerCode => $playerInfo) {
            if ($playerInfo['status'] == 1) { // 只返回启用的播放器
                $playerList[] = [
                    'playerCode' => $playerCode,
                    'playerName' => $playerInfo['show']
                ];
            }
        }

        // 6. 构建返回数据
        $result = [
            'code' => 200,
            'msg' => '成功',
            'data' => [
                'userId' => $adConfig['user_id'] ?? 0,
                'enableSplash' => (bool)($adConfig['ad_splash_status'] ?? false),
                'enableInterstitial' => (bool)($adConfig['ad_home_page_insert_status'] ?? false),
                'enableHomeBanner' => (bool)($adConfig['ad_home_banner_status'] ?? false),
                'enableRankFeed' => (bool)($adConfig['ad_rank_feed_status'] ?? false),
                'enableHistoryFeed' => (bool)($adConfig['ad_history_feed_status'] ?? false),
                'enableSearchBanner' => (bool)($adConfig['ad_search_page_banner_status'] ?? false),
                'enableSearchResultFeed' => (bool)($adConfig['ad_search_feed_status'] ?? false),
                'enableMyBanner' => (bool)($adConfig['ad_mine_page_banner_status'] ?? false),
                'enablePlayerFeed' => (bool)($adConfig['ad_play_feed_status'] ?? false),
                'enablePlayerRewarded' => (bool)($adConfig['enablePlayerRewarded'] ?? false),
                'detailstatus' => (bool)($adConfig['detailstatus'] ?? false),
                // 修改以下字段从系统配置表获取
                'danmUrl' => $systemConfig['danmu_settings'] ?? '',
                'globalVideoDataUrl' => $GLOBALS['http_type'] . $_SERVER['HTTP_HOST'] . "/api.php/provide/vod/",
                'shareText' => $systemConfig['share_text'] ?? '',
                'bottomNva' => $systemConfig['bottom_nav'] ?? '',
                'notice' => $systemConfig['public_settings'] ?? '',
                'shadingLayer' => $systemConfig['shading_layer'] ?? '',
                // 添加openSearch参数
                'openSearch' => (bool)$searchEnable,

                'playerList' => $playerList,
                'jiexiDataList' => array_map(function ($item) {
                    return [
                        'url' => $item['parse_url'] ?? '',
                        'name' => $item['parse_name'] ?? '',
                        'playerCode' => $item['player_code'] ?? '',
                        'directConcat' => (bool)($item['is_direct'] ?? false),
                        'playerType' => $item['player_type'] ?? 'IJK'
                    ];
                }, $parseList),
                'searchDataList' => array_map(function ($item) {
                    return [
                        'id' => $item['id'] ?? 0,
                        'name' => $item['search_name'] ?? '',
                        'url' => $item['search_url'] ?? '',
                        'sortOrder' => $item['sort_order'] ?? null
                    ];
                }, $searchList)
            ]
        ];

      // 转换数组为 JSON 字符串
        $jsonStr = json_encode($result, JSON_UNESCAPED_UNICODE);
        
        // 【加密】
        $encryptedData = $this->encryptResponseData($jsonStr);
        
        // 直接输出加密字符串，或者包装一层 JSON (推荐直接输出字符串，减少体积)
        // 如果客户端希望收到的是纯文本密文：
        return response($encryptedData)->contentType('text/plain');
    }
    
    private static function getSystemConfig()
{
    $config = Db::table('appfox_system_config')->find();
    if (!$config) {
        throw new \Exception('系统配置未找到');
    }
    return $config;
}



}