﻿# Xunsearch 全文检索插件 - 项目文档

## 项目概述

本项目是为 **Maccms V10（苹果CMS）** 开发的高性能全文检索插件，用于替换系统默认的 SQL 模糊搜索，集成 **Xunsearch（迅搜）** 全文搜索引擎以提供更快速、更精准的搜索体验。

### 核心信息

| 项目 | 值 |
|------|-----|
| 插件名称 | xunsearch |
| 插件标题 | 迅搜全文检索 |
| 版本 | 1.0.0 |
| 作者 | TraeAI |
| 框架 | ThinkPHP (Maccms V10) |
| 搜索引擎 | Xunsearch (迅搜) |

### 技术栈

- **后端语言**: PHP 7.0+
- **框架**: ThinkPHP 5.x / 6.x (Maccms V10)
- **搜索引擎**: Xunsearch (基于 SCWS 分词)
- **数据库**: MySQL (仅用于读取数据，搜索使用 Xunsearch)

---

## 目录结构

`
addons/xunsearch/
├── info.ini                 # 插件元信息配置
├── config.php               # 插件配置项定义
├── Xunsearch.php            # 插件主类，定义钩子和安装逻辑
├── README.md                # 用户使用文档
├── TROUBLESHOOTING.md       # 故障排查文档
├── ini/
│   └── vod.ini              # Xunsearch 项目字段配置
├── library/
│   └── XsService.php        # Xunsearch 服务封装类
├── controller/
│   └── Index.php            # 前台搜索控制器
├── view/
│   └── search.html          # 搜索结果页模板
└── sdk/
    └── lib/                 # Xunsearch SDK 存放目录（需要手动安装）
`

---

## 核心功能

### 1. 全文搜索

插件支持对视频数据的多字段模糊搜索，包括：
- **vod_name** (视频名称) - 标题字段，支持分词
- **vod_actor** (演员) - 混合索引
- **vod_director** (导演) - 混合索引
- **vod_en** (英文名) - 混合索引
- **vod_sub** (副标题) - 混合索引
- **vod_content** (剧情简介) - 内容字段

搜索逻辑：
`php
// 支持 OR 逻辑，任意字段匹配即返回
query = "vod_name:{\} OR vod_actor:{\} OR vod_director:{\}"
`

### 2. 自动索引同步

通过 Maccms 钩子机制实现索引的自动更新：

| 钩子 | 触发时机 | 功能 |
|------|----------|------|
| fterVodSave | 后台添加/编辑视频后 | 自动更新该视频的索引 |
| fterVodDelete | 后台删除视频后 | 自动删除该视频的索引 |

### 3. 索引管理

提供两种索引管理模式：

#### 全量重建
- 清空现有索引，重新导入所有视频数据
- 适用场景：首次安装、数据严重不一致
- 支持 Web 界面和 CLI 命令两种方式
- 实时显示处理进度

#### 增量更新
- 仅更新最近 2 小时内修改的视频
- 适用场景：日常维护，定期执行
- 速度快，不影响前台性能
- 推荐配置为计划任务每 30 分钟或 1 小时执行一次

---

## 安装与配置

### 1. 上传插件

将 ddons/xunsearch 目录上传到 Maccms 网站根目录的 ddons 文件夹下。

**正确的目录结构应为：**
`
/您的网站目录/addons/xunsearch/
├── info.ini
├── Xunsearch.php
└── ...
`

### 2. 安装 Xunsearch SDK

**注意**：由于版权和大小原因，插件包未包含 SDK。

#### 方式一：从 Xunsearch 服务器复制
`ash
# 如果您的服务器已安装 Xunsearch
cp -r /usr/local/xunsearch/sdk/php/lib/* addons/xunsearch/sdk/lib/
`

#### 方式二：下载官方 SDK
1. 访问 [Xunsearch 官网](http://www.xunsearch.com/download/xunsearch-full-latest.zip)
2. 下载并解压
3. 将 lib 目录内容复制到 ddons/xunsearch/sdk/lib/

**最终应包含：**
`
addons/xunsearch/sdk/lib/XS.php
`

### 3. 后台配置

1. 登录 Maccms 后台
2. 进入 **应用** → **应用市场**（或插件管理）
3. 找到 **迅搜全文检索** 插件，点击 **安装** → **启用**
4. 点击 **配置**，设置以下参数：

| 配置项 | 默认值 | 说明 |
|--------|--------|------|
| 索引服务端地址 | 45.153.131.78:8383 | Xunsearch 索引服务地址，本地使用 127.0.0.1:8383 |
| 搜索服务端地址 | 45.153.131.78:8384 | Xunsearch 搜索服务地址，本地使用 127.0.0.1:8384 |
| 项目名称 | vod | Xunsearch 项目名称，对应 ini 文件名 |

### 4. 初始化索引

首次安装后需要执行全量重建：

#### Web 界面操作
在插件配置页面底部，点击 **执行全量重建** 按钮。

#### CLI 命令
`ash
cd /www/wwwroot/您的网站目录
php index.php addons/xunsearch/index/rebuild
`

---

## 构建与运行

### 前台搜索集成

#### 方式一：修改前台搜索表单（推荐）
在您主题的搜索表单中，将 ction 地址修改为：

`html
<form action="{:addon_url('xunsearch/index/search')}" method="get">
    <input type="text" name="wd" placeholder="请输入关键词">
    <button type="submit">搜索</button>
</form>
`

#### 方式二：仅后台使用（不影响前台）
如果只想在后台使用插件搜索，而不修改前台模板：
- 前台网站将继续使用默认的 SQL 搜索
- 后台可以通过插件配置页面的搜索功能使用 Xunsearch
- 两者互不影响

### 计划任务配置（推荐）

为保持索引实时性，建议在服务器面板添加计划任务：

#### 增量更新（每 30 分钟或 1 小时）
`
任务类型: Shell 脚本
脚本内容:
cd /www/wwwroot/您的网站目录
php index.php addons/xunsearch/index/update
`

#### 全量重建（每周或每月）
`
任务类型: Shell 脚本
脚本内容:
cd /www/wwwroot/您的网站目录
php index.php addons/xunsearch/index/rebuild
`

### CLI 命令

`ash
# 进入网站目录
cd /www/wwwroot/您的网站目录

# 全量重建索引
php index.php addons/xunsearch/index/rebuild

# 增量更新索引（最近2小时）
php index.php addons/xunsearch/index/update

# 执行搜索（需要修改 controller 返回 JSON）
php index.php addons/xunsearch/index/search?wd=关键词
`

---

## 开发规范

### 命名空间约定

- **插件主类**: ddons\xunsearch
- **控制器**: ddons\xunsearch\controller
- **服务类**: ddons\xunsearch\library

### 数据库字段映射

插件使用 Maccms 标准的 od 表字段：

| Maccms 字段 | 索引类型 | 说明 |
|-------------|----------|------|
| vod_id | id | 主键 |
| type_id | numeric | 分类ID |
| vod_name | title (scws) | 视频名称，支持中文分词 |
| vod_en | mixed | 英文名 |
| vod_sub | mixed | 副标题 |
| vod_actor | mixed | 演员 |
| vod_director | mixed | 导演 |
| vod_content | body | 剧情简介 |
| vod_time | numeric | 更新时间 |

### 错误处理

插件使用 Try-Catch 捕获异常，并通过 ThinkPHP 的 	race() 函数记录错误：

`php
try {
    // 业务逻辑
} catch (\Exception \) {
    if (function_exists('trace')) {
        trace('Xunsearch Error: ' . \->getMessage());
    }
}
`

### 配置获取

插件配置通过 get_addon_config() 函数获取：

`php
\ = get_addon_config('xunsearch');
\ = \['xs_server_index'] ?? '127.0.0.1:8383';
`

---

## 常见问题排查

### 插件无法识别

1. **清除缓存**：后台首页 → 清除缓存
2. **检查目录结构**：确保文件在正确位置
3. **检查文件权限**：Linux 服务器设置为 755/644
4. **检查文件编码**：info.ini 必须是 UTF-8 编码
5. **检查命名空间**：确保 info.ini、Xunsearch.php 中的名称一致

### SDK 未找到错误

确保 SDK 已正确安装到以下位置之一：
- ddons/xunsearch/sdk/lib/XS.php（优先）
- /usr/local/xunsearch/sdk/php/lib/XS.php

### 搜索服务异常

1. 检查 Xunsearch 服务是否启动
2. 检查防火墙端口 8383/8384 是否开放
3. 验证配置的服务器地址是否正确
4. 本地连接使用 127.0.0.1 而非 localhost

### 索引更新不及时

1. 检查钩子是否正常触发
2. 检查 fterVodSave 和 fterVodDelete 方法
3. 查看错误日志排查异常
4. 手动执行增量更新命令

---

## 核心文件说明

### Xunsearch.php

插件主类，继承自 	hink\Addons，定义：
- 插件元信息 (\)
- 安装/卸载方法 (install()/uninstall())
- 钩子方法 (fterVodSave(), fterVodDelete())

### library/XsService.php

Xunsearch 服务封装类，提供：
- 构造函数：初始化 Xunsearch 连接
- search(): 执行搜索
- ddIndex(): 添加索引
- updateIndex(): 更新索引
- deleteIndex(): 删除索引
- clean(): 清空索引
- 
ebuildAll(): 全量重建

### controller/Index.php

前台控制器，提供：
- search(): 搜索接口
- 
ebuild(): 全量重建（Web + CLI）
- update(): 增量更新（Web + CLI）
- 
ebuildProcess(): 重建内部处理逻辑

### ini/vod.ini

Xunsearch 项目配置文件，定义：
- 项目名称和字符集
- 各字段的索引类型和分词规则

---

## 注意事项

1. **Xunsearch 服务要求**：确保 Xunsearch 服务已启动并正常运行
2. **端口开放**：检查防火墙是否开放 8383（索引）和 8384（搜索）端口
3. **本地连接**：本地连接建议使用 127.0.0.1 而非 localhost
4. **SDK 安装**：插件不包含 SDK，需要手动安装
5. **索引一致性**：定期执行增量更新保持索引实时性
6. **内存限制**：全量重建时建议设置 memory_limit 为 512M 或更高
7. **执行时间**：索引操作使用 set_time_limit(0) 避免超时

---

## 扩展开发

### 添加新的搜索字段

1. 修改 ini/vod.ini 添加字段定义
2. 修改 library/XsService.php 的 ddIndex() 和 updateIndex() 方法
3. 修改 controller/Index.php 的 
ebuildProcess() 方法查询新字段

### 自定义搜索模板

复制 iew/search.html 到您的主题目录进行修改，保持变量名称不变。

### API 接口扩展

修改 controller/Index.php 的 search() 方法，添加 JSON 输出逻辑：

`php
if (\['out'] == 'json') {
    return json(\);
}
`

---

## 许可与支持

- **官网**: https://www.maccms.com
- **Xunsearch 官网**: http://www.xunsearch.com
- **插件版本**: 1.0.0
- **开发作者**: TraeAI

如有问题，请参考 TROUBLESHOOTING.md 文件或联系插件作者。
