# Maccms V10 迅搜 (Xunsearch) 全文检索插件

本插件用于将苹果CMS (Maccms V10) 的默认搜索替换为高性能的迅搜 (Xunsearch) 全文检索。

## 目录结构
```
addons/xunsearch/
├── info.ini                 # 插件信息
├── config.php               # 插件配置
├── Xunsearch.php            # 核心逻辑与钩子
├── ini/
│   └── vod.ini              # 迅搜项目配置
├── library/
│   └── XsService.php        # 迅搜服务封装
├── controller/
│   └── Index.php            # 前台搜索控制器
├── view/c

### 1. 上传插件
将 `addons/xunsearch` 目录上传到您的 Maccms 网站根目录的 `addons` 文件夹下。

### 2. 添加 Xunsearch SDK
由于版权和大小原因，插件包未包含 SDK。
请从您的迅搜服务器 `/usr/local/xunsearch/sdk/php/lib/` 目录复制所有文件，
或者从 [Xunsearch官网](http://www.xunsearch.com/download/xunsearch-full-latest.zip) 下载 SDK 包，解压后将 `lib` 目录下的内容放入 `addons/xunsearch/sdk/lib/` 目录中。
最终结构应为：
`addons/xunsearch/sdk/lib/XS.php`

### 3. 安装与配置
1. 登录 Maccms 后台，进入 **应用** -> **应用市场** (或插件管理)。
2. 找到 **迅搜全文检索** 插件，点击 **安装** -> **启用**。
3. 点击 **配置**，确认迅搜服务端地址 (默认已根据您的服务器配置为 45.153.131.78)。

### 4. 索引管理 (Web & 宝塔计划任务)

#### 方式一：后台 Web 操作 (可视化进度)
在插件配置页面底部，点击以下按钮：
- **全量重建索引**：清空现有索引并重新导入所有视频数据。适用于初次安装或数据严重不一致。
- **增量更新索引**：仅扫描并更新最近 2 小时内变动的视频。速度快，建议日常维护使用。

点击后会跳转到执行页面，显示实时进度日志。

#### 方式二：宝塔计划任务 (推荐)
为了保持数据实时性且不影响前台性能，建议在宝塔面板添加计划任务。

**1. 增量更新 (建议每 30 分钟或 1 小时执行一次)**
任务类型：Shell 脚本
脚本内容：
```bash
# 请将下面的路径修改为您网站的实际根目录
cd /www/wwwroot/您的网站目录
php index.php addons/xunsearch/index/update
```

**2. 全量重建 (建议每周或每月执行一次)**
任务类型：Shell 脚本
脚本内容：
```bash
# 请将下面的路径修改为您网站的实际根目录
cd /www/wwwroot/您的网站目录
php index.php addons/xunsearch/index/rebuild
```

### 5. APP 接口与前台搜索
- **前台 PC/H5**：插件默认提供了 `search.html` 模板。如果您希望前台搜索使用迅搜，请修改您主题的搜索表单 action 地址为 `{:addon_url('xunsearch/index/search')}`。
- **APP / API**：如果您主要使用 APP 获取数据，且 APP 调用的是 Maccms 默认的 API 接口 (`api.php/provide/vod` 等)，本插件**不会**自动拦截 API 请求。
    - **如果 APP 需要使用迅搜**：您需要修改 APP 的搜索接口请求地址，指向插件的搜索接口：
      `http://您的域名/index.php/addons/xunsearch/index/search?wd=关键字&out=json`
      *(注：目前插件默认返回 HTML，如需 JSON 格式，需修改 `controller/Index.php` 增加 json 输出逻辑)*
    - **不修改主题的影响**：如果您只在后台开启插件用于 APP 搜索，而不修改前台主题模板，那么前台网站依然会使用默认的 SQL 搜索，两者互不影响。

## 注意事项
- 确保迅搜服务 (xunsearch) 已启动并在防火墙放行 8383/8384 端口。
- 如果是本地连接，建议配置中使用 `127.0.0.1`。
