# 插件无法识别排查指南

如果您在后台 **应用** -> **应用市场** -> **本地应用** 中看不到“迅搜全文检索”插件，请尝试以下步骤：

## 1. 清除缓存 (最常见原因)
Maccms 会缓存插件列表。
*   进入后台首页。
*   点击右上角的 **清除缓存** (或在“系统”菜单中找到)。
*   刷新“应用市场”页面。

## 2. 检查目录结构
确保插件文件上传到了正确的位置。
正确的服务器路径应为：
`/您的网站目录/addons/xunsearch/`

在该目录下应该能看到以下文件：
*   `info.ini`
*   `Plugin.php`
*   `config.php`
*   ...

**错误示例**：
*   `/addons/xunsearch/xunsearch/info.ini` (多了一层目录)
*   `/addons/info.ini` (文件散落在外面)

## 3. 检查文件权限 (Linux服务器)
如果您使用的是 Linux 服务器，请确保插件目录有读取权限。
建议设置目录权限为 `755`，文件权限为 `644`。
```bash
chmod -R 755 addons/xunsearch
```

## 4. 检查文件编码
`info.ini` 必须是 **UTF-8** 编码。如果出现乱码，后台可能无法解析从而忽略该插件。

## 5. 检查 PHP 命名空间
如果您修改了插件文件夹名称 (例如改为 `xs`)，则必须同时修改：
1.  `info.ini` 中的 `name = xs`
2.  `Plugin.php` 中的 `namespace addons\xs;`
3.  `Plugin.php` 中的 `$info['name'] = 'xs';`

**必须保持三者一致！** 建议保持默认的 `xunsearch` 不变。

## 6. 手动访问测试
尝试直接访问插件的类，看是否报错。
如果开启了调试模式，可以在后台首页查看是否有报错日志。
