<?php
namespace addons\xunsearch;

use think\Addons;
use think\Db;
use addons\xunsearch\library\XsService;

class Xunsearch extends Addons
{
    // Force refresh cache
    public $info = [
        'name' => 'xunsearch',
        'title' => '迅搜全文检索',
        'intro' => '替换Maccms默认搜索，使用Xunsearch提供高性能搜索支持',
        'author' => 'TraeAI',
        'version' => '1.1.0',
        'state' => 1,
    ];

    public function install()
    {
        // 创建后台管理菜单
        $this->createMenu();
        return true;
    }

    public function uninstall()
    {
        // 删除后台管理菜单
        $this->deleteMenu();
        return true;
    }
    
    /**
     * 创建后台管理菜单
     */
    private function createMenu()
    {
        try {
            // 检查菜单是否已存在
            $exists = Db::name('menu')->where('menu_name', 'xunsearch')->find();
            if ($exists) {
                return true;
            }
            
            $menu = [
                'menu_name' => 'xunsearch',
                'menu_title' => '讯搜后台管理',
                'menu_parent' => 0,
                'menu_url' => 'addons/xunsearch/admin/index',
                'menu_icon' => 'layui-icon-search',
                'menu_sort' => 100,
                'menu_type' => 1,
            ];
            $menuId = Db::name('menu')->insertGetId($menu);
            if ($menuId) {
                return true;
            }
        } catch (\Exception $e) {
            // 菜单创建失败不影响安装
        }
        return false;
    }
    
    /**
     * 删除后台管理菜单
     */
    private function deleteMenu()
    {
        try {
            Db::name('menu')->where('menu_name', 'xunsearch')->delete();
        } catch (\Exception $e) {
            // 菜单删除失败不影响卸载
        }
    }

    /**
     * Hook: After saving video data (add or update)
     * This hook is triggered when a video is added or edited in the backend
     */
    public function afterVodSave($params)
    {
        try {
            $data = $params;
            
            // Ensure we have the data we need
            if (!isset($data['vod_id'])) {
                // Try to find data in sub-keys if structure is different
                if (isset($params['data'])) {
                    $data = $params['data'];
                }
            }
            
            if (!empty($data['vod_id'])) {
                $xs = new XsService();
                $xs->updateIndex($data);
            }
        } catch (\Exception $e) {
            // Log error using ThinkPHP's trace or log
            if (function_exists('trace')) {
                trace('Xunsearch Error: ' . $e->getMessage());
            }
        }
        return true;
    }

    /**
     * Hook: After deleting video data
     */
    public function afterVodDelete($params)
    {
        try {
            $ids = $params;
            if (is_array($params) && isset($params['ids'])) {
                $ids = $params['ids'];
            }
            
            if (!empty($ids)) {
                $xs = new XsService();
                $xs->deleteIndex($ids);
            }
        } catch (\Exception $e) {
            if (function_exists('trace')) {
                trace('Xunsearch Error: ' . $e->getMessage());
            }
        }
        return true;
    }
}
