<?php
namespace addons\xunsearch\controller;

use think\Controller;
use think\Db;
use addons\xunsearch\library\XsService;

class Index extends Controller
{
    public function search()
    {
        $param = input();
        $wd = $param['wd'] ?? '';
        $page = $param['page'] ?? 1;
        $limit = 20;
        
        if (empty($wd)) {
            $this->error('请输入关键字');
        }
        
        try {
            $xs = new XsService();
            $res = $xs->search($wd, $page, $limit);
            
            // Assign variables to template
            $this->assign('list', $res['list']);
            $this->assign('total', $res['total']);
            $this->assign('count', $res['count']);
            $this->assign('page', $page);
            $this->assign('limit', $limit);
            $this->assign('wd', $wd);
            $this->assign('param', $param);
            
            // Calculate pagination pages
            $pages = ceil($res['total'] / $limit);
            $this->assign('pages', $pages);
            
            // Render the plugin's view
            return $this->fetch('view/search');
            
        } catch (\Exception $e) {
            $this->error('搜索服务异常：' . $e->getMessage());
        }
    }
    
    /**
     * Rebuild index for all videos
     * This action should be called from backend or via CLI
     */
    public function rebuild()
    {
        // Check admin permission (simple check based on session)
        if (!session('admin_id') && !request()->isCli()) {
            $this->error('无权操作');
        }
        
        // Disable timeout
        set_time_limit(0);
        ini_set('memory_limit', '512M');
        
        if (!request()->isCli()) {
            // Output header for browser to stream content
            header('Content-Type: text/html; charset=utf-8');
            header('X-Accel-Buffering: no'); // Nginx
            ob_end_flush();
            ob_implicit_flush(1);
            
            echo '<style>body{font-family: Consolas,Monaco,monospace; background:#222; color:#0f0; padding:20px; line-height:1.5;}</style>';
            echo '<h3>开始全量重建索引...</h3>';
            echo '<hr>';
        }
        
        try {
            $xs = new XsService();
            // Call internal method to rebuild with callback
            $this->rebuildProcess($xs);
            
            if (!request()->isCli()) {
                echo '<hr><h3>索引重建完成!</h3>';
            }
        } catch (\Exception $e) {
            if (request()->isCli()) {
                echo "Error: " . $e->getMessage() . "\n";
            } else {
                echo '<p style="color:red">重建失败：' . $e->getMessage() . '</p>';
            }
        }
    }
    
    /**
     * Incremental update for recently changed videos
     * Updates videos changed in the last 2 hours
     */
    public function update()
    {
        // Check admin permission
        if (!session('admin_id') && !request()->isCli()) {
            $this->error('无权操作');
        }
        
        set_time_limit(0);
        
        if (!request()->isCli()) {
            header('Content-Type: text/html; charset=utf-8');
            header('X-Accel-Buffering: no');
            ob_end_flush();
            ob_implicit_flush(1);
            
            echo '<style>body{font-family: Consolas,Monaco,monospace; background:#222; color:#0f0; padding:20px; line-height:1.5;}</style>';
            echo '<h3>开始增量更新索引...</h3>';
            echo '<p>正在查找最近更新的视频...</p>';
            echo '<hr>';
        }
        
        try {
            $xs = new XsService();
            // 🔴 修复时区漏洞：扩大抓取时间范围到过去 24 小时（86400秒），绝对防止漏剧！
            $time_limit = time() - 86400; 
            
            $where = [
                ['vod_time', '>', $time_limit]
            ];
            
            $count = Db::name('vod')->where($where)->count();
            
            if (!request()->isCli()) {
                echo "<p>找到 {$count} 个视频需要更新。</p>";
            } else {
                echo "Found {$count} videos to update.\n";
            }
            
            if ($count > 0) {
                // 🔴 修复致命字段缺失：追加了 vod_pic, vod_remarks 等 APP 必须的字段！
                $list = Db::name('vod')->where($where)->field('vod_id,vod_name,type_id,vod_en,vod_sub,vod_actor,vod_director,vod_content,vod_time,vod_pic,vod_remarks')->select();
                foreach($list as $v) {
                    $xs->updateIndex($v);
                    if (!request()->isCli()) {
                        echo "<div>[ID:{$v['vod_id']}] {$v['vod_name']} ... <span style='color:yellow'>Updated</span></div>";
                        flush();
                    } else {
                        echo "[ID:{$v['vod_id']}] {$v['vod_name']} ... Updated\n";
                    }
                }
                
                // 🔴 修复内存未刷入硬盘漏洞：强制立即生效！
                $xs->getXs()->getIndex()->flushIndex();
            }
            
            if (!request()->isCli()) {
                echo '<hr><h3>增量更新完成!</h3>';
            }
        } catch (\Exception $e) {
            if (request()->isCli()) {
                echo "Error: " . $e->getMessage() . "\n";
            } else {
                echo '<p style="color:red">更新失败：' . $e->getMessage() . '</p>';
            }
        }
    }

    /**
     * Internal process for rebuilding
     */
    private function rebuildProcess($xs)
    {
        $xs->clean(); // Custom clean method needed or use beginRebuild
        
        $limit = 500;
        $page = 1;
        $total_processed = 0;
        
        while(true) {
            // 🔴 修复全量重建的字段缺失：追加了 vod_pic, vod_remarks 等 APP 必须的字段！
            $list = Db::name('vod')->field('vod_id,vod_name,type_id,vod_en,vod_sub,vod_actor,vod_director,vod_content,vod_time,vod_pic,vod_remarks')->page($page, $limit)->select();
            if(empty($list)) break;
            
            foreach($list as $v) {
                $xs->addIndex($v); // Use add instead of update for speed during rebuild
                $total_processed++;
                
                if ($total_processed % 100 == 0) {
                    if (!request()->isCli()) {
                        echo "<div>已处理 {$total_processed} 条数据...</div>";
                        echo '<script>window.scrollTo(0,document.body.scrollHeight);</script>';
                        flush();
                    } else {
                        echo "Processed {$total_processed} records...\n";
                    }
                }
            }
            $page++;
        }
        
        // 🔴 全量重建完毕强制立即生效
        $xs->getXs()->getIndex()->flushIndex();
        
        if (!request()->isCli()) {
            echo "<div>总计处理 {$total_processed} 条数据。</div>";
        }
    }
}