<?php
namespace addons\xunsearch\library;

use think\Db;

if (file_exists(__DIR__ . '/../sdk/lib/XS.php')) {
    require_once __DIR__ . '/../sdk/lib/XS.php';
} elseif (file_exists('/usr/local/xunsearch/sdk/php/lib/XS.php')) {
    require_once '/usr/local/xunsearch/sdk/php/lib/XS.php';
}

class XsService
{
    private $xs;
    private $project;
    private $config;

    public function getXs()
    {
        return $this->xs;
    }

    public function __construct()
    {
        $this->config = get_addon_config('xunsearch');
        $this->project = $this->config['xs_project'] ?? 'vod';
        $iniPath = __DIR__ . '/../ini/' . $this->project . '.ini';
        
        if (!class_exists('XS')) {
            if (file_exists('/usr/local/xunsearch/sdk/php/lib/XS.php')) {
                require_once '/usr/local/xunsearch/api/php/lib/XS.php';
            }
            
            if (!class_exists('XS')) {
                throw new \Exception('Xunsearch SDK not found. Please install SDK to addons/xunsearch/sdk/ or ensure it is installed on the server.');
            }
        }

        try {
            $this->xs = new \XS($iniPath);
        } catch (\Exception $e) {
            throw $e;
        }
    }

 public function search($keyword, $page = 1, $limit = 20)
   {
       $search = $this->xs->getSearch();
       $search->setCharset('UTF-8');
       $search->setFuzzy(true);
       $query = "vod_name:{$keyword} OR vod_actor:{$keyword} OR vod_director:{$keyword}";

       // 先搜索获取总数（不限制数量，只取前1000条来估算总数）
       $search->setQuery($query);
       $search->setLimit(1000, 0);
       $docs = $search->search();
       $total = $search->getLastCount();  // 获取所有匹配结果数

       // 如果总数大于当前页限制，重新搜索获取当前页数据
       if ($total > 0) {
           $docs = $search->setLimit($limit, ($page - 1) * $limit)->search();
       }

       $count = $search->getLastCount();  // 获取当前页结果数

       $list = [];
       foreach ($docs as $doc) {
           $list[] = [
               'vod_id' => $doc->id,
               'vod_name' => $doc->vod_name,
               'type_id' => $doc->type_id,
               'vod_en' => $doc->vod_en,
               'vod_time' => $doc->vod_time,
               'vod_actor' => $doc->vod_actor,
               'vod_director' => $doc->vod_director,
           ];
       }
       return ['list' => $list, 'total' => $total, 'count' => $count];
   }

    public function addIndex($data)
    {
        $index = $this->xs->getIndex();
        $doc = new \XSDocument();
        $doc->setFields([
            'id' => $data['vod_id'],
            'vod_name' => $data['vod_name'],
            'type_id' => $data['type_id'],
            'vod_en' => $data['vod_en'] ?? '',
            'vod_sub' => $data['vod_sub'] ?? '',
            'vod_actor' => $data['vod_actor'] ?? '',
            'vod_director' => $data['vod_director'] ?? '',
            'vod_content' => strip_tags($data['vod_content'] ?? ''),
            'vod_time' => $data['vod_time'] ?? time(),
        ]);
        $index->add($doc);
    }

    public function clean() 
    {
        $this->xs->getIndex()->clean();
    }

    public function updateIndex($data)
    {
        $index = $this->xs->getIndex();
        $doc = new \XSDocument();
        $doc->setFields([
            'id' => $data['vod_id'],
            'vod_name' => $data['vod_name'],
            'type_id' => $data['type_id'],
            'vod_en' => $data['vod_en'] ?? '',
            'vod_sub' => $data['vod_sub'] ?? '',
            'vod_actor' => $data['vod_actor'] ?? '',
            'vod_director' => $data['vod_director'] ?? '',
            'vod_content' => strip_tags($data['vod_content'] ?? ''),
            'vod_time' => $data['vod_time'] ?? time(),
        ]);
        $index->update($doc);
    }
    
    public function deleteIndex($ids)
    {
        $index = $this->xs->getIndex();
        $index->del($ids);
    }

    public function rebuildAll()
    {
        $index = $this->xs->getIndex();
        $index->beginRebuild();
        $limit = 1000;
        $page = 1;
        while(true) {
            if (!class_exists('think\Db')) break;
            $list = Db::name('vod')->field('vod_id,vod_name,type_id,vod_en,vod_sub,vod_actor,vod_director,vod_content,vod_time')->page($page, $limit)->select();
            if(empty($list)) break;
            foreach($list as $v) {
                $doc = new \XSDocument();
                $doc->setFields([
                    'id' => $v['vod_id'],
                    'vod_name' => $v['vod_name'],
                    'type_id' => $v['type_id'],
                    'vod_en' => $v['vod_en'],
                    'vod_sub' => $v['vod_sub'],
                    'vod_actor' => $v['vod_actor'],
                    'vod_director' => $v['vod_director'],
                    'vod_content' => strip_tags($v['vod_content']),
                    'vod_time' => $v['vod_time'],
                ]);
                $index->add($doc);
            }
            $page++;
        }
        $index->endRebuild();
    }
}
