<?php

/**
 * 苹果CMS数据接口类
 * 将此文件复制到苹果CMS的application/api/controller/中
 * lvdoui.net
 **/

namespace app\api\controller;

use think\Db;
use think\Cache;

class App extends Base
{

    var $_param;
    private $EncryptionDetails = false; // true、开启加密   false、关闭加密
    private $cmskey = "ziKv8NzFSwNoBUYRJclwwjRaiTWBb7MH"; //对应后台设置的API接口密钥，可在线生成https://www.bchrt.com/tools/random-string-generator/  ziKv8NzFSwNoBUYRJclwwjRaiTWBb7ON

    public function __construct()
    {
        parent::__construct();
        $this->_param = input();
    }

   /**
    * 极速索引直查 + 讯搜融合引擎 (TVBox抗CC死锁版)
    */
    private function searchWithXunsearch($keyword)
    {
        // 🛡️ 1. 物理级防CC：超长乱码直接丢弃，不给数据库任何压力
        if (mb_strlen($keyword, 'utf-8') > 20) {
            return ['code' => 1, 'msg' => '搜索', 'list' => [], 'total' => 0];
        }

        $exact_ids = [];
        // 🚀 2. O(1) 极速索引直查：解决讯搜外剧分词问题，0.001秒返回，绝不死锁！
        try {
            $exact_ids = Db::name('vod')->where('vod_name', '=', $keyword)->column('vod_id') ?: [];
            $prefix_ids = Db::name('vod')->where('vod_name', 'like', $keyword . '%')->limit(10)->column('vod_id') ?: [];
            $exact_ids = array_unique(array_merge($exact_ids, $prefix_ids));
        } catch (\Exception $e) {}

        // 🔍 3. 讯搜模糊兜底
        $fuzzy_ids = [];
        try {
            $xs_path = dirname(dirname(dirname(__DIR__))) . '/addons/xunsearch/library/XsService.php';
            if (file_exists($xs_path)) {
                require_once $xs_path;
                if (class_exists('addons\xunsearch\library\XsService')) {
                    $xs = new \addons\xunsearch\library\XsService();
                    $result = $xs->search($keyword, 1, 100);

                    if ($result && $result['total'] > 0) {
                        foreach ($result['list'] as $v) {
                            if (!empty($v['vod_id'])) {
                                $fuzzy_ids[] = $v['vod_id'];
                            }
                        }
                    }
                }
            }
        } catch (\Exception $e) {}

        // 🏆 4. 合并并输出：极速直查死死钉在最前面！
        $final_ids = array_unique(array_merge($exact_ids, $fuzzy_ids));
        $final_ids = array_slice($final_ids, 0, 100);

        // 如果两个引擎都没找到，直接返回空格式，彻底阻断向下退化
        if (empty($final_ids)) {
            return ['code' => 1, 'msg' => '搜索', 'list' => [], 'total' => 0];
        }

        $ids_str = implode(',', $final_ids);
        $field = 'vod_id,vod_name,vod_pic,vod_pic_slide,vod_score,type_id,vod_en,vod_time_add,vod_remarks,vod_play_from,vod_play_url';
        
        try {
            // 【第五步】从数据库获取最终数据，严格按合并后的 ID 顺序排列
            $list = Db::name('vod')
                ->field($field)
                ->where('vod_id', 'in', $final_ids)
                ->order(Db::raw("field(vod_id," . $ids_str . ")"))
                ->select();

            $type_list = model('Type')->getCache('type_list');
            $group_list = model('Group')->getCache('group_list');

            foreach ($list as $k => $v) {
                if (!empty($v['type_id'])) {
                    $type_info = $type_list[$v['type_id']] ?? [];
                    $list[$k]['type'] = $type_info;
                    if (!empty($type_info['type_pid'])) {
                        $list[$k]['type_1'] = $type_list[$type_info['type_pid']] ?? [];
                    } else {
                        $list[$k]['type_1'] = [];
                    }
                }
                if (!empty($v['group_id'])) {
                    $list[$k]['group'] = $group_list[$v['group_id']] ?? [];
                }
                if (!is_numeric($list[$k]['vod_time_add'])) {
                    $list[$k]['vod_time_add'] = strtotime($list[$k]['vod_time_add']);
                }
            }

            return [
                'code' => 1,
                'msg' => '搜索',
                'list' => $list,
                'total' => count($final_ids)
            ];

        } catch (\Exception $e) {
            return ['code' => 1, 'msg' => '搜索', 'list' => [], 'total' => 0];
        }
    }


    private function json_encode_extra($obj, $apicode = "")
    {
        return json_encode($obj, JSON_UNESCAPED_SLASHES | JSON_UNESCAPED_UNICODE);
    }

    // aes加密函数
    private function AESencrypt($data)
    {
        $encryptedData = openssl_encrypt($data, "AES-128-CBC", substr($this->cmskey, 0, 16), OPENSSL_RAW_DATA, substr($this->cmskey, -16));
        return "lvdou+" . base64_encode($encryptedData);
    }

    /**
     * 视频json，带分类
     */
    public function vod_json($v)
    {
        if ($v == null) {
            return $v;
        }
        $v['vod_time_add'] = date('Y-m-d H:i:s', $v['vod_time_add']);
        $v['vod_content'] = strip_tags($v['vod_content']);
        if (substr($v["vod_pic"], 0, 4) == "mac:") {
            $v["vod_pic"] = str_replace('mac:', 'http:', $v["vod_pic"]);
        } elseif (substr($v["vod_pic"], 0, 2) == "//") {
            $v["vod_pic"] = str_replace('//', 'http://', $v["vod_pic"]);
        } elseif (!empty($v["vod_pic"]) && substr($v["vod_pic"], 0, 4) != "http" && substr($v["vod_pic"], 0, 2) != "//") {
            $v["vod_pic"] = $GLOBALS['config']['api']['vod']['imgurl'] . $v["vod_pic"];
        }

        if (substr($v["vod_pic_slide"], 0, 4) == "mac:") {
            $v["vod_pic_slide"] = str_replace('mac:', 'http:', $v["vod_pic_slide"]);
        } elseif (substr($v["vod_pic_slide"], 0, 2) == "//") {
            $v["vod_pic_slide"] = str_replace('//', 'http://', $v["vod_pic_slide"]);
        } elseif (!empty($v["vod_pic_slide"]) && substr($v["vod_pic_slide"], 0, 4) != "http" && substr($v["vod_pic_slide"], 0, 2) != "//") {
            $v["vod_pic_slide"] = $GLOBALS['config']['api']['vod']['imgurl'] . $v["vod_pic_slide"];
        }

        $v["vod_url_with_player"] = [];
        $vod_play_from_array = explode('$$$', $v["vod_play_from"]);
        $play_url_array = explode('$$$', $v["vod_play_url"]);
        $all_players = config("vodplayer");
        $xg_parse_players = config("vodplayer_xg_parse");
        $sort = [];
        foreach ($vod_play_from_array as $k => $player) {
            try {
                if ($all_players[$player]['show'] != null && $all_players[$player]['status'] == 1 && ($xg_parse_players[$player]['app_is_show'] == 1 || $xg_parse_players[$player]['app_is_show'] == null)) {
                    
                    // 屏蔽指定播放器
                    $banPlayer = ['SHNB', 'QingShan', 'YYNB', 'HBO', 'Ace', 'NBY','hqdj','http','XOV'];   // 按需写
                    if (in_array($player, $banPlayer)) {
                        continue;
                    }
                    
                    $player_sort = $all_players[$player]['sort'];
                    $player_sort = $player_sort == "" ? 0 : $player_sort;
                    $player_with_url = [];
                    $player_with_url["name"] = $all_players[$player]['show'];
                    $player_with_url["code"] = $all_players[$player]['from'];
                    $player_with_url["url"] = $play_url_array[$k];
                    if (empty($xg_parse_players[$player]['parse_api'])) {
                        $player_with_url["parse_api"] = $xg_parse_players['xg_app_player']['parse_api'];
                    } else {
                        $player_with_url["parse_api"] = $xg_parse_players[$player]['parse_api'];
                    }
                    if (empty($xg_parse_players[$player]['user_agent'])) {
                        $player_with_url["user_agent"] = $xg_parse_players['xg_app_player']['user_agent'];
                    } else {
                        $player_with_url["user_agent"] = $xg_parse_players[$player]['user_agent'];
                    }
                    if (empty($xg_parse_players[$player]['headers'])) {
                        $player_with_url["headers"] = $xg_parse_players['xg_app_player']['headers'];
                    } else {
                        $player_with_url["headers"] = $xg_parse_players[$player]['headers'];
                    }
                    if (empty($xg_parse_players[$player]['link_features'])) {
                        $player_with_url["link_features"] = $xg_parse_players['xg_app_player']['link_features'];
                    } else {
                        $player_with_url["link_features"] = $xg_parse_players[$player]['link_features'];
                    }
                    if (empty($xg_parse_players[$player]['un_link_features'])) {
                        $player_with_url["un_link_features"] = $xg_parse_players['xg_app_player']['un_link_features'];
                    } else {
                        $player_with_url["un_link_features"] = $xg_parse_players[$player]['un_link_features'];
                    }
                    $sort[] = $player_sort;
                    array_push($v["vod_url_with_player"], $player_with_url);
                }
            } catch (\Exception $e) {
            }
        }
        array_multisort($sort, SORT_DESC, $v["vod_url_with_player"]);
        return $v;
    }

    /**
     * 视频列表，不带分类（仅用于不需要播放器的场景）
     */
    public function vod_json_list($res)
    {
        if(empty($res['list'])) return $res;
        
        foreach ($res['list'] as $k => &$v) {
            $v['vod_time_add'] = date('Y-m-d H:i:s', $v['vod_time_add']);
            if (substr($v["vod_pic"], 0, 4) == "mac:") {
                $v["vod_pic"] = str_replace('mac:', 'http:', $v["vod_pic"]);
            } elseif (substr($v["vod_pic"], 0, 2) == "//") {
                $v["vod_pic"] = str_replace('//', 'http://', $v["vod_pic"]);
            } elseif (!empty($v["vod_pic"]) && substr($v["vod_pic"], 0, 4) != "http" && substr($v["vod_pic"], 0, 2) != "//") {
                $v["vod_pic"] = $GLOBALS['config']['api']['vod']['imgurl'] . $v["vod_pic"];
            }
            if (substr($v["vod_pic_slide"], 0, 4) == "mac:") {
                $v["vod_pic_slide"] = str_replace('mac:', 'http:', $v["vod_pic_slide"]);
            } elseif (substr($v["vod_pic_slide"], 0, 2) == "//") {
                $v["vod_pic_slide"] = str_replace('//', 'http://', $v["vod_pic_slide"]);
            } elseif (!empty($v["vod_pic_slide"]) && substr($v["vod_pic_slide"], 0, 4) != "http" && substr($v["vod_pic_slide"], 0, 2) != "//") {
                $v["vod_pic_slide"] = $GLOBALS['config']['api']['vod']['imgurl'] . $v["vod_pic_slide"];
            }
        }
        return $res;
    }

    /**
     * 视频检索
     */
    public function search()
    {
        $keyword = trim($this->_param['text'] ?? '');
        
        // 🛡️ 防CC 拦截1：空词直接返回
        if (empty($keyword)) {
            $res = ['code' => 1, 'msg' => '搜索', 'list' => [], 'total' => 0];
            echo $this->json_encode_extra($res, "search");
            exit;
        }

        // 检查缓存
        if (Cache::has('xgapp_search' . $keyword)) {
            $cache_response = Cache::get('xgapp_search' . $keyword);
            echo $this->json_encode_extra($cache_response, "search");
            exit;
        }
        
        // 🚀 核心搜索调用：100% 交给我们写好的双引擎去查，无论查没查到，都不允许往下跑危险代码
        $xs_res = $this->searchWithXunsearch($keyword);
        
        // 格式化输出并缓存
        $res = $this->vod_json_list($xs_res);
        Cache::set('xgapp_search' . $keyword, $res, 60 * 60);
        
        echo $this->json_encode_extra($res, "search");
        exit;
    }

    /**
     * banner
     * 预留
     */
    public function banner()
    {
        if (Cache::has('xgapp_banner')) {
            $cache_list = Cache::get('xgapp_banner');
            $response = ['code' => 1, 'msg' => '轮播图', 'list' => $cache_list];
            $html = $this->json_encode_extra($response, "banner");
            echo $html;
            exit;
        }
        $html = '';
        $where = [];
        $where['vod_level'] = ['eq', 9];
        $order = 'vod_time desc';
        $field = 'vod_id,vod_name,vod_pic,vod_pic_slide,vod_score,type_id,vod_en,vod_time_add,vod_remarks';
        $res = model('vod')->listData($where, $order, 1, $GLOBALS['config']['api']['vod']['pagesize'], 0, $field, 0);
        foreach ($res["list"] as $k => &$v) {
            if (!empty($v["vod_pic_slide"])) {
                $v['vod_pic'] = $v['vod_pic_slide'];
            }
        }
        $list_array = $this->vod_json_list($res)["list"];
        Cache::set('xgapp_banner', $list_array, 60 * 60);
        $response = ['code' => 1, 'msg' => '轮播图', 'list' => $list_array];
        $html = $this->json_encode_extra($response, "banner");
        echo $html;
        exit;
    }

    /**
     * 首页推荐（优化版：直接返回带播放器的完整视频数据，避免TVBox额外请求video_detail）
     */
    public function index_video()
    {
        if (Cache::has('xgapp_index_video')) {
            $cache_list = Cache::get('xgapp_index_video');
            $response = ['code' => 1, 'msg' => '首页视频', 'list' => $cache_list];
            $html = $this->json_encode_extra($response, "index_video");
            echo $html;
            exit;
        }

        $type_where = ["type_status" => 1];
        $type_order = 'type_sort';
        $type_list = model('type')->listData($type_where, $type_order, 'tree', 1, 1000, 0, 0)["list"];
        $type_list_array = [];

        foreach ($type_list as $k => $v) {
            $type_info = [
                "type_id" => $v["type_id"],
                "type_name" => '精选' . $v["type_name"]
            ];

            $where = [];
            $where['type_id|type_id_1'] = ['eq', $v["type_id"]];
            $where['vod_level'] = ['lt', 2];
            $order = 'vod_level desc,vod_time desc';
            // 👇 关键：增加 vod_play_from 和 vod_play_url 字段
            $field = 'vod_id,vod_name,vod_pic,type_id,vod_remarks,vod_play_from,vod_play_url';
            $limit_str = '6';

            $list = Db::name('vod')
                ->field($field)
                ->where($where)
                ->order($order)
                ->limit($limit_str)
                ->select();

            // 👇 对每条视频使用 vod_json 处理，生成带播放器的数据
            foreach ($list as &$item) {
                $item = $this->vod_json($item);
            }

            $type_info["vlist"] = $list;
            $type_list_array[] = $type_info;
        }

        Cache::set('xgapp_index_video', $type_list_array, 5 * 60);
        $response = ['code' => 1, 'msg' => '首页视频', 'list' => $type_list_array];
        $html = $this->json_encode_extra($response, "index_video");
        echo $html;
        exit;
    }
    
    /**
     * 导航
     */
    public function nav()
    {
        if (Cache::has('xgapp_nav')) {
            $cache_list = Cache::get('xgapp_nav');
            $response = ['code' => 1, 'msg' => '导航列表', 'list' => $cache_list];
            $html = $this->json_encode_extra($response, "nav");
            echo $html;
            exit;
        }
        $html = '';
        $type_where = [];
        $type_where["type_status"] = 1;
        $type_order = 'type_sort';
        $type_list = model('type')->listData($type_where, $type_order, 'tree', 1, 1000, 0, 0)["list"];
        $type_list_array = [];
        foreach ($type_list as $k => $v) {
            $type_info["type_id"] = $v["type_id"];
            $type_info["type_name"] = $v["type_name"];
            $type_info["type_extend"] = $v["type_extend"];
            array_push($type_list_array, $type_info);
        }
        Cache::set('xgapp_nav', $type_list_array, 60 * 60);
        $response = ['code' => 1, 'msg' => '导航列表', 'list' => $type_list_array];
        $html = $this->json_encode_extra($response, "nav");
        echo $html;
        exit;
    }

    /**
     * 视频筛选
     */
    public function video()
    {
        if (empty($this->_param["tid"])) {
            $json = $this->json_encode_extra(['code' => 2, 'msg' => '参数验证失败'], "video");
            echo $json;
            exit;
        }
        $html = '';
        $where = [];
        $where['type_id | type_id_1'] = ['eq', $this->_param['tid']];
        if (!empty($this->_param['class'])) {
            $where['vod_class'] = ['like', "%" . $this->_param['class'] . "%"];
        }
        if (!empty($this->_param['area'])) {
            $where['vod_area'] = ['like', "%" . $this->_param['area'] . "%"];
        }
        if (!empty($this->_param['lang'])) {
            $where['vod_lang'] = ['like', "%" . $this->_param['lang'] . "%"];
        }
        if (!empty($this->_param['year'])) {
            $where['vod_year'] = ['like', "%" . $this->_param['year'] . "%"];
        }
        if (empty($this->_param['pg'])) {
            $this->_param['pg'] = 1;
        }
        if ($this->_param['pg'] > 25) {
            $this->_param['pg'] = 25;
        }
        $order = 'vod_time desc';
        $field = 'vod_id,vod_name,vod_pic,vod_score,type_id,vod_en,vod_time_add,vod_remarks';
        $res = model('vod')->listData($where, $order, $this->_param['pg'], $GLOBALS['config']['api']['vod']['pagesize'], 0, $field, 0);
        $html = $this->json_encode_extra($this->vod_json_list($res), "video");
        echo $html;
        exit;
    }

    /**
     * 视频详情
     */
    public function video_detail()
    {
        if (empty($this->_param['id'])) {
            $json = $this->json_encode_extra(['code' => 2, 'msg' => '参数验证失败'], "video_detail");
            echo $json;
            exit;
        }
        $html = '';
        $where = [];
        if (!empty($this->_param['id'])) {
            $where['vod_id'] = ['eq', $this->_param['id']];
        }
        if (empty($this->_param['id'])) {
            $where['vod_id'] = ['eq', 1];
        }
        $order = 'vod_time desc';
        $field = '*';
        $res = Db::name('vod')->field($field)->where($where)->find();
        if (empty($res)) {
            $json = $this->json_encode_extra(['code' => 404, 'msg' => '抱歉，该视频已下架'], "video_detail");
            echo $json;
            exit;
        }

        if ($this->EncryptionDetails) {
            $dataArray = explode('#', $res['vod_play_url']);
            foreach ($dataArray as &$data) {
                $segments = explode('$', $data);
                if (count($segments) === 2) {
                    $title = $segments[0];
                    $url = $segments[1];
                    $encodedUrl = $this->AESencrypt($url);
                    $data = $title . '$' . $encodedUrl;
                }
            }
            $res['vod_play_url'] = implode('#', $dataArray);
        }

        $detail = $this->vod_json($res);
        $detail["trysee"] = config("maccms")["user"]["trysee"];
        if ($detail["permission"] != "vip") {
            $where = [];
            $where['status'] = ['eq', 1];
            $where['start_time'] = ['lt', time()];
            $where['end_time'] = ['gt',  time()];
            $start = 0;
            $limit = 20;
            $order = 'rand()';
            $field = 'id,name,content,req_type,req_content,headers,time,skip_time';
            $init_advert_list = [];
            $enable = config('maccms')["xg_advert_config"]["config_video_start"];
            if ($enable == 1) {
                $where['position'] = ['eq', 3];
                $limit_str = $start . "," . $limit;
                $init_advert_list = Db::table('xg_app_advert')->field($field)->where($where)->orderRaw($order)->limit($limit_str)->select();
            }
            foreach ($init_advert_list as $k => &$v) {
                if (substr($v["content"], 0, 4) == "mac:") {
                    $v["content"] = str_replace('mac:', 'http:', $v["content"]);
                } elseif (substr($v["content"], 0, 2) == "//") {
                    $v["content"] = str_replace('//', 'http://', $v["content"]);
                } elseif (!empty($v["content"]) && substr($v["content"], 0, 4) != "http" && substr($v["content"], 0, 2) != "//") {
                    $v["content"] = $GLOBALS['config']['api']['vod']['imgurl'] . $v["content"];
                }
                $init_advert_list[$k] = $v;
            }
            $pause_advert_list = [];
            $enable = config('maccms')["xg_advert_config"]["config_video_pause"];
            if ($enable == 1) {
                $where['position'] = ['eq', 4];
                $limit_str = $start . "," . $limit;
                $pause_advert_list = Db::table('xg_app_advert')->field($field)->where($where)->orderRaw($order)->limit($limit_str)->select();
            }
            foreach ($pause_advert_list as $k => &$v) {
                if (substr($v["content"], 0, 4) == "mac:") {
                    $v["content"] = str_replace('mac:', 'http:', $v["content"]);
                } elseif (substr($v["content"], 0, 2) == "//") {
                    $v["content"] = str_replace('//', 'http://', $v["content"]);
                } elseif (!empty($v["content"]) && substr($v["content"], 0, 4) != "http" && substr($v["content"], 0, 2) != "//") {
                    $v["content"] = $GLOBALS['config']['api']['vod']['imgurl'] . $v["content"];
                }
                $pause_advert_list[$k] = $v;
            }
            $detail["init_advert_list"] = $init_advert_list;
            $detail["pause_advert_list"] = $pause_advert_list;
        }
        if ($detail["unlock"]) {
            $response = ['code' => 1024, 'msg' => '权限不足', 'data' => $detail];
            $html = $this->json_encode_extra($response, "video_detail");
            echo $html;
            exit;
        }
        $response = ['code' => 1, 'msg' => '视频详情', 'data' => $detail];
        $html = $this->json_encode_extra($response, "video_detail");
        echo $html;
        exit;
    }
}